/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import ej.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class Logger {
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Nullable
    protected Level effectiveLevel;
    @Nullable
    protected Level publicLevel;
    @Nullable
    private final String name;
    @Nullable
    private Logger parent;
    private final List<Handler> handlers;

    protected Logger(@Nullable String name, @Nullable String resourceBundleName) {
        this.name = name;
        this.handlers = new ArrayList<Handler>();
        this.publicLevel = null;
        this.effectiveLevel = null;
    }

    public static Logger getAnonymousLogger() {
        Logger logger = new Logger(null, null);
        logger.setParent(LogManager.getLogManager().rootLogger);
        logger.setLevel(Level.ALL);
        return logger;
    }

    public static Logger getLogger(String name) {
        String lowerCaseName = name.toLowerCase();
        Logger logger = LogManager.getLogManager().getLogger(lowerCaseName);
        if (logger == null) {
            logger = new Logger(lowerCaseName, null);
            logger.setParent(LogManager.getLogManager().rootLogger);
            LogManager.getLogManager().addLogger(logger);
        }
        return logger;
    }

    public static final Logger getGlobal() {
        return Logger.getLogger(GLOBAL_LOGGER_NAME);
    }

    public void addHandler(Handler handler) {
        this.handlers.add(handler);
    }

    public void config(@Nullable String msg) {
        this.log(Level.CONFIG, msg);
    }

    public void fine(@Nullable String msg) {
        this.log(Level.FINE, msg);
    }

    public void finer(@Nullable String msg) {
        this.log(Level.FINER, msg);
    }

    public void finest(@Nullable String msg) {
        this.log(Level.FINEST, msg);
    }

    @Nullable
    public Level getLevel() {
        return this.publicLevel;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    @Nullable
    public Logger getParent() {
        return this.parent;
    }

    public void info(@Nullable String msg) {
        this.log(Level.INFO, msg);
    }

    public boolean isLoggable(Level level) {
        Level effectiveLevel = this.effectiveLevel;
        assert (effectiveLevel != null);
        return level.intValue() >= effectiveLevel.intValue();
    }

    public void log(Level level, @Nullable String msg) {
        this.log(level, msg, null);
    }

    public void log(Level level, @Nullable String msg, @Nullable Throwable thrown) {
        LogRecord record = new LogRecord(level, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    public void log(LogRecord record) {
        Level effectiveLevel = this.effectiveLevel;
        assert (effectiveLevel != null);
        if (effectiveLevel.intValue() <= record.getLevel().intValue()) {
            if (record.getLoggerName() == null) {
                record.setLoggerName(this.name);
            }
            this.passToHandlers(record);
            Logger parent = this.parent;
            if (parent != null) {
                parent.logFromChild(record);
            }
        }
    }

    private void logFromChild(LogRecord record) {
        this.passToHandlers(record);
        Logger parent = this.parent;
        if (parent != null) {
            parent.logFromChild(record);
        }
    }

    private void passToHandlers(LogRecord record) {
        for (Handler handler : this.handlers) {
            handler.publish(record);
        }
    }

    public void removeHandler(Handler handler) {
        this.handlers.remove(handler);
    }

    public void setLevel(@Nullable Level newLevel) {
        this.publicLevel = newLevel;
        this.updateLevel();
    }

    void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException("Parent cannot be null");
        }
        if (this != parent) {
            this.parent = parent;
            this.updateLevel();
        }
    }

    public void severe(@Nullable String msg) {
        this.log(Level.SEVERE, msg);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.log(Level.FINER, String.valueOf(sourceClass) + "." + sourceMethod, thrown);
    }

    private void updateLevel() {
        if (this.publicLevel == null) {
            Logger parent = this.parent;
            if (parent != null) {
                this.effectiveLevel = parent.getLevel();
            }
        } else {
            this.effectiveLevel = this.publicLevel;
        }
    }

    public void warning(@Nullable String msg) {
        this.log(Level.WARNING, msg);
    }
}

