/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Arrays;
import sun.misc.FDBigInteger;

public class FloatingDecimal {
    static final int EXP_SHIFT = 52;
    static final long FRACT_HOB = 0x10000000000000L;
    static final long EXP_ONE = 0x3FF0000000000000L;
    static final int MAX_SMALL_BIN_EXP = 62;
    static final int MIN_SMALL_BIN_EXP = -21;
    static final int MAX_DECIMAL_DIGITS = 15;
    static final int MAX_DECIMAL_EXPONENT = 308;
    static final int MIN_DECIMAL_EXPONENT = -324;
    static final int BIG_DECIMAL_EXPONENT = 324;
    static final int MAX_NDIGITS = 1100;
    static final int SINGLE_EXP_SHIFT = 23;
    static final int SINGLE_FRACT_HOB = 0x800000;
    static final int SINGLE_MAX_DECIMAL_DIGITS = 7;
    static final int SINGLE_MAX_DECIMAL_EXPONENT = 38;
    static final int SINGLE_MIN_DECIMAL_EXPONENT = -45;
    static final int SINGLE_MAX_NDIGITS = 200;
    static final int INT_DECIMAL_DIGITS = 9;
    private static final String INFINITY_REP = "Infinity";
    private static final String NAN_REP = "NaN";
    private static final BinaryToASCIIConverter B2AC_POSITIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("Infinity", false);
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_INFINITY = new ExceptionalBinaryToASCIIBuffer("-Infinity", true);
    private static final BinaryToASCIIConverter B2AC_NOT_A_NUMBER = new ExceptionalBinaryToASCIIBuffer("NaN", false);
    private static final BinaryToASCIIConverter B2AC_POSITIVE_ZERO = new BinaryToASCIIBuffer(false, new char[]{'0'});
    private static final BinaryToASCIIConverter B2AC_NEGATIVE_ZERO = new BinaryToASCIIBuffer(true, new char[]{'0'});

    static BinaryToASCIIConverter getBinaryToASCIIConverter(double d, Object arg) {
        int nSignificantBits;
        long dBits = Double.doubleToRawLongBits(d);
        boolean isNegative = (dBits & Long.MIN_VALUE) != 0L;
        long fractBits = dBits & 0xFFFFFFFFFFFFFL;
        int binExp = (int)((dBits & 0x7FF0000000000000L) >> 52);
        if (binExp == 2047) {
            if (fractBits == 0L) {
                return isNegative ? B2AC_NEGATIVE_INFINITY : B2AC_POSITIVE_INFINITY;
            }
            return B2AC_NOT_A_NUMBER;
        }
        if (binExp == 0) {
            if (fractBits == 0L) {
                return isNegative ? B2AC_NEGATIVE_ZERO : B2AC_POSITIVE_ZERO;
            }
            int leadingZeros = FloatingDecimal.numberOfLeadingZeros(fractBits);
            int shift = leadingZeros - 11;
            fractBits <<= shift;
            binExp = 1 - shift;
            nSignificantBits = 64 - leadingZeros;
        } else {
            fractBits |= 0x10000000000000L;
            nSignificantBits = 53;
        }
        BinaryToASCIIBuffer buf = new BinaryToASCIIBuffer();
        buf.setSign(isNegative);
        buf.dtoa(binExp -= 1023, fractBits, nSignificantBits, arg);
        return buf;
    }

    public static int numberOfLeadingZeros(long i) {
        if (i == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(i >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)i;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static int numberOfTrailingZeros(long i) {
        int x;
        if (i == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)i;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(i >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    static class BinaryToASCIIBuffer
    implements BinaryToASCIIConverter {
        private boolean isNegative;
        private int decExponent;
        private int firstDigitIndex;
        private int nDigits;
        private final char[] digits;
        private final char[] buffer = new char[26];
        private boolean exactDecimalConversion = false;
        private boolean decimalDigitsRoundedUp = false;
        private static int[] insignificantDigitsNumber;
        private static final int[] N_5_BITS;

        static {
            int[] nArray = new int[64];
            nArray[4] = 1;
            nArray[5] = 1;
            nArray[6] = 1;
            nArray[7] = 2;
            nArray[8] = 2;
            nArray[9] = 2;
            nArray[10] = 3;
            nArray[11] = 3;
            nArray[12] = 3;
            nArray[13] = 3;
            nArray[14] = 4;
            nArray[15] = 4;
            nArray[16] = 4;
            nArray[17] = 5;
            nArray[18] = 5;
            nArray[19] = 5;
            nArray[20] = 6;
            nArray[21] = 6;
            nArray[22] = 6;
            nArray[23] = 6;
            nArray[24] = 7;
            nArray[25] = 7;
            nArray[26] = 7;
            nArray[27] = 8;
            nArray[28] = 8;
            nArray[29] = 8;
            nArray[30] = 9;
            nArray[31] = 9;
            nArray[32] = 9;
            nArray[33] = 9;
            nArray[34] = 10;
            nArray[35] = 10;
            nArray[36] = 10;
            nArray[37] = 11;
            nArray[38] = 11;
            nArray[39] = 11;
            nArray[40] = 12;
            nArray[41] = 12;
            nArray[42] = 12;
            nArray[43] = 12;
            nArray[44] = 13;
            nArray[45] = 13;
            nArray[46] = 13;
            nArray[47] = 14;
            nArray[48] = 14;
            nArray[49] = 14;
            nArray[50] = 15;
            nArray[51] = 15;
            nArray[52] = 15;
            nArray[53] = 15;
            nArray[54] = 16;
            nArray[55] = 16;
            nArray[56] = 16;
            nArray[57] = 17;
            nArray[58] = 17;
            nArray[59] = 17;
            nArray[60] = 18;
            nArray[61] = 18;
            nArray[62] = 18;
            nArray[63] = 19;
            insignificantDigitsNumber = nArray;
            int[] nArray2 = new int[27];
            nArray2[1] = 3;
            nArray2[2] = 5;
            nArray2[3] = 7;
            nArray2[4] = 10;
            nArray2[5] = 12;
            nArray2[6] = 14;
            nArray2[7] = 17;
            nArray2[8] = 19;
            nArray2[9] = 21;
            nArray2[10] = 24;
            nArray2[11] = 26;
            nArray2[12] = 28;
            nArray2[13] = 31;
            nArray2[14] = 33;
            nArray2[15] = 35;
            nArray2[16] = 38;
            nArray2[17] = 40;
            nArray2[18] = 42;
            nArray2[19] = 45;
            nArray2[20] = 47;
            nArray2[21] = 49;
            nArray2[22] = 52;
            nArray2[23] = 54;
            nArray2[24] = 56;
            nArray2[25] = 59;
            nArray2[26] = 61;
            N_5_BITS = nArray2;
        }

        BinaryToASCIIBuffer() {
            this.digits = new char[20];
        }

        BinaryToASCIIBuffer(boolean isNegative, char[] digits) {
            this.isNegative = isNegative;
            this.decExponent = 0;
            this.digits = digits;
            this.firstDigitIndex = 0;
            this.nDigits = digits.length;
        }

        @Override
        public String toJavaFormatString() {
            int len = this.getChars(this.buffer);
            return new String(this.buffer, 0, len);
        }

        @Override
        public void appendTo(Appendable buf) {
            int len = this.getChars(this.buffer);
            if (buf instanceof StringBuilder) {
                ((StringBuilder)buf).append(this.buffer, 0, len);
            } else if (buf instanceof StringBuffer) {
                ((StringBuffer)buf).append(this.buffer, 0, len);
            } else assert (false);
        }

        @Override
        public int getDecimalExponent() {
            return this.decExponent;
        }

        @Override
        public int getDigits(char[] digits) {
            System.arraycopy(this.digits, this.firstDigitIndex, digits, 0, this.nDigits);
            return this.nDigits;
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public boolean isExceptional() {
            return false;
        }

        @Override
        public boolean digitsRoundedUp() {
            return this.decimalDigitsRoundedUp;
        }

        @Override
        public boolean decimalDigitsExact() {
            return this.exactDecimalConversion;
        }

        private void setSign(boolean isNegative) {
            this.isNegative = isNegative;
        }

        private void developLongDigits(int decExponent, long lvalue, int insignificantDigits) {
            if (insignificantDigits != 0) {
                long pow10 = FDBigInteger.LONG_5_POW[insignificantDigits] << insignificantDigits;
                long residue = lvalue % pow10;
                lvalue /= pow10;
                decExponent += insignificantDigits;
                if (residue >= pow10 >> 1) {
                    ++lvalue;
                }
            }
            int digitno = this.digits.length - 1;
            if (lvalue <= Integer.MAX_VALUE) {
                assert (lvalue > 0L) : lvalue;
                int ivalue = (int)lvalue;
                int c = ivalue % 10;
                ivalue /= 10;
                while (c == 0) {
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                while (ivalue != 0) {
                    this.digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = ivalue % 10;
                    ivalue /= 10;
                }
                this.digits[digitno] = (char)(c + 48);
            } else {
                int c = (int)(lvalue % 10L);
                lvalue /= 10L;
                while (c == 0) {
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                while (lvalue != 0L) {
                    this.digits[digitno--] = (char)(c + 48);
                    ++decExponent;
                    c = (int)(lvalue % 10L);
                    lvalue /= 10L;
                }
                this.digits[digitno] = (char)(c + 48);
            }
            this.decExponent = decExponent + 1;
            this.firstDigitIndex = digitno;
            this.nDigits = this.digits.length - digitno;
        }

        private void dtoa(int binExp, long fractBits, int nSignificantBits, Object arg) {
            long lowDigitDifference;
            boolean high;
            boolean low;
            assert (fractBits > 0L);
            assert ((fractBits & 0x10000000000000L) != 0L);
            int tailZeros = FloatingDecimal.numberOfTrailingZeros(fractBits);
            int nFractBits = 53 - tailZeros;
            this.decimalDigitsRoundedUp = false;
            this.exactDecimalConversion = false;
            int nTinyBits = Math.max(0, nFractBits - binExp - 1);
            if (binExp <= 62 && binExp >= -21 && nTinyBits < FDBigInteger.LONG_5_POW.length && nFractBits + N_5_BITS[nTinyBits] < 64 && nTinyBits == 0) {
                int insignificant = binExp > nSignificantBits ? BinaryToASCIIBuffer.insignificantDigitsForPow2(binExp - nSignificantBits - 1) : 0;
                fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
                this.developLongDigits(0, fractBits, insignificant);
                return;
            }
            int decExp = BinaryToASCIIBuffer.estimateDecExp(fractBits, binExp);
            int B5 = Math.max(0, -decExp);
            int B2 = B5 + nTinyBits + binExp;
            int S5 = Math.max(0, decExp);
            int S2 = S5 + nTinyBits;
            int M5 = B5;
            int M2 = B2 - nSignificantBits;
            fractBits >>>= tailZeros;
            int common2factor = Math.min(B2 -= nFractBits - 1, S2);
            B2 -= common2factor;
            S2 -= common2factor;
            M2 -= common2factor;
            if (nFractBits == 1) {
                --M2;
            }
            if (M2 < 0) {
                B2 -= M2;
                S2 -= M2;
                M2 = 0;
            }
            int ndigit = 0;
            int Bbits = nFractBits + B2 + (B5 < N_5_BITS.length ? N_5_BITS[B5] : B5 * 3);
            int tenSbits = S2 + 1 + (S5 + 1 < N_5_BITS.length ? N_5_BITS[S5 + 1] : (S5 + 1) * 3);
            if (Bbits < 64 && tenSbits < 64) {
                if (Bbits < 32 && tenSbits < 32) {
                    int b = (int)fractBits * FDBigInteger.SMALL_5_POW[B5] << B2;
                    int s = FDBigInteger.SMALL_5_POW[S5] << S2;
                    int m = FDBigInteger.SMALL_5_POW[M5] << M2;
                    int tens = s * 10;
                    ndigit = 0;
                    int q = b / s;
                    low = (b = 10 * (b % s)) < (m *= 10);
                    boolean bl = high = b + m > tens;
                    assert (q < 10) : q;
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    if (decExp < -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = b / s;
                        b = 10 * (b % s);
                        m *= 10;
                        assert (q < 10) : q;
                        if ((long)m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                    this.exactDecimalConversion = b == 0;
                } else {
                    long b = fractBits * FDBigInteger.LONG_5_POW[B5] << B2;
                    long s = FDBigInteger.LONG_5_POW[S5] << S2;
                    long m = FDBigInteger.LONG_5_POW[M5] << M2;
                    long tens = s * 10L;
                    ndigit = 0;
                    int q = (int)(b / s);
                    low = (b = 10L * (b % s)) < (m *= 10L);
                    boolean bl = high = b + m > tens;
                    assert (q < 10) : q;
                    if (q == 0 && !high) {
                        --decExp;
                    } else {
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    if (decExp < -3 || decExp >= 8) {
                        low = false;
                        high = false;
                    }
                    while (!low && !high) {
                        q = (int)(b / s);
                        b = 10L * (b % s);
                        m *= 10L;
                        assert (q < 10) : q;
                        if (m > 0L) {
                            low = b < m;
                            high = b + m > tens;
                        } else {
                            low = true;
                            high = true;
                        }
                        this.digits[ndigit++] = (char)(48 + q);
                    }
                    lowDigitDifference = (b << 1) - tens;
                    this.exactDecimalConversion = b == 0L;
                }
            } else {
                FDBigInteger Sval = FDBigInteger.valueOfPow52((int)S5, (int)S2);
                int shiftBias = Sval.getNormalizationBias();
                Sval = Sval.leftShift(shiftBias);
                FDBigInteger Bval = FDBigInteger.valueOfMulPow52((long)fractBits, (int)B5, (int)(B2 + shiftBias));
                FDBigInteger Mval = FDBigInteger.valueOfPow52((int)(M5 + 1), (int)(M2 + shiftBias + 1));
                FDBigInteger tenSval = FDBigInteger.valueOfPow52((int)(S5 + 1), (int)(S2 + shiftBias + 1));
                ndigit = 0;
                int q = Bval.quoRemIteration(Sval);
                low = Bval.cmp(Mval) < 0;
                boolean bl = high = tenSval.addAndCmp(Bval, Mval) <= 0;
                assert (q < 10) : q;
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    this.digits[ndigit++] = (char)(48 + q);
                }
                if (decExp < -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = Bval.quoRemIteration(Sval);
                    assert (q < 10) : q;
                    low = Bval.cmp(Mval = Mval.multBy10()) < 0;
                    high = tenSval.addAndCmp(Bval, Mval) <= 0;
                    this.digits[ndigit++] = (char)(48 + q);
                }
                if (high && low) {
                    Bval = Bval.leftShift(1);
                    lowDigitDifference = Bval.cmp(tenSval);
                } else {
                    lowDigitDifference = 0L;
                }
                this.exactDecimalConversion = Bval.cmp(FDBigInteger.ZERO) == 0;
            }
            this.decExponent = decExp + 1;
            this.firstDigitIndex = 0;
            this.nDigits = ndigit;
            if (high) {
                if (low) {
                    if (lowDigitDifference == 0L) {
                        if ((this.digits[this.firstDigitIndex + this.nDigits - 1] & '\u0001') != 0) {
                            this.roundup();
                        }
                    } else if (lowDigitDifference > 0L) {
                        this.roundup();
                    }
                } else {
                    this.roundup();
                }
            }
        }

        private void roundup() {
            int i = this.firstDigitIndex + this.nDigits - 1;
            char q = this.digits[i];
            if (q == '9') {
                while (q == '9' && i > this.firstDigitIndex) {
                    this.digits[i] = 48;
                    q = this.digits[--i];
                }
                if (q == '9') {
                    ++this.decExponent;
                    this.digits[this.firstDigitIndex] = 49;
                    return;
                }
            }
            this.digits[i] = (char)(q + '\u0001');
            this.decimalDigitsRoundedUp = true;
        }

        static int estimateDecExp(long fractBits, int binExp) {
            boolean isNegative;
            double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFFFFFFFFFFFFL);
            double d = (d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981;
            long dBits = Double.doubleToRawLongBits(d);
            int exponent = (int)((dBits & 0x7FF0000000000000L) >> 52) - 1023;
            boolean bl = isNegative = (dBits & Long.MIN_VALUE) != 0L;
            if (exponent >= 0 && exponent < 52) {
                long mask = 0xFFFFFFFFFFFFFL >> exponent;
                int r = (int)((dBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L) >> 52 - exponent);
                return isNegative ? ((mask & dBits) == 0L ? -r : -r - 1) : r;
            }
            if (exponent < 0) {
                return (dBits & Long.MAX_VALUE) == 0L ? 0 : (isNegative ? -1 : 0);
            }
            return (int)d;
        }

        private static int insignificantDigitsForPow2(int p2) {
            if (p2 > 1 && p2 < insignificantDigitsNumber.length) {
                return insignificantDigitsNumber[p2];
            }
            return 0;
        }

        private int getChars(char[] result) {
            assert (this.nDigits <= 19) : this.nDigits;
            int i = 0;
            if (this.isNegative) {
                result[0] = 45;
                i = 1;
            }
            if (this.decExponent > 0 && this.decExponent < 8) {
                int charLength = Math.min(this.nDigits, this.decExponent);
                System.arraycopy(this.digits, this.firstDigitIndex, result, i, charLength);
                i += charLength;
                if (charLength < this.decExponent) {
                    charLength = this.decExponent - charLength;
                    Arrays.fill(result, i, i + charLength, '0');
                    i += charLength;
                    result[i++] = 46;
                    result[i++] = 48;
                } else {
                    result[i++] = 46;
                    if (charLength < this.nDigits) {
                        int t = this.nDigits - charLength;
                        System.arraycopy(this.digits, this.firstDigitIndex + charLength, result, i, t);
                        i += t;
                    } else {
                        result[i++] = 48;
                    }
                }
            } else if (this.decExponent <= 0 && this.decExponent > -3) {
                result[i++] = 48;
                result[i++] = 46;
                if (this.decExponent != 0) {
                    Arrays.fill(result, i, i - this.decExponent, '0');
                    i -= this.decExponent;
                }
                System.arraycopy(this.digits, this.firstDigitIndex, result, i, this.nDigits);
                i += this.nDigits;
            } else {
                int e;
                result[i++] = this.digits[this.firstDigitIndex];
                result[i++] = 46;
                if (this.nDigits > 1) {
                    System.arraycopy(this.digits, this.firstDigitIndex + 1, result, i, this.nDigits - 1);
                    i += this.nDigits - 1;
                } else {
                    result[i++] = 48;
                }
                result[i++] = 69;
                if (this.decExponent <= 0) {
                    result[i++] = 45;
                    e = -this.decExponent + 1;
                } else {
                    e = this.decExponent - 1;
                }
                if (e <= 9) {
                    result[i++] = (char)(e + 48);
                } else if (e <= 99) {
                    result[i++] = (char)(e / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                } else {
                    result[i++] = (char)(e / 100 + 48);
                    result[i++] = (char)((e %= 100) / 10 + 48);
                    result[i++] = (char)(e % 10 + 48);
                }
            }
            return i;
        }
    }

    public static interface BinaryToASCIIConverter {
        public String toJavaFormatString();

        public void appendTo(Appendable var1);

        public int getDecimalExponent();

        public int getDigits(char[] var1);

        public boolean isNegative();

        public boolean isExceptional();

        public boolean digitsRoundedUp();

        public boolean decimalDigitsExact();
    }

    private static class ExceptionalBinaryToASCIIBuffer
    implements BinaryToASCIIConverter {
        private final String image;
        private final boolean isNegative;

        public ExceptionalBinaryToASCIIBuffer(String image, boolean isNegative) {
            this.image = image;
            this.isNegative = isNegative;
        }

        @Override
        public String toJavaFormatString() {
            return this.image;
        }

        @Override
        public void appendTo(Appendable buf) {
            if (buf instanceof StringBuilder) {
                ((StringBuilder)buf).append(this.image);
            } else if (buf instanceof StringBuffer) {
                ((StringBuffer)buf).append(this.image);
            } else assert (false);
        }

        @Override
        public int getDecimalExponent() {
            throw new IllegalArgumentException("Exceptional value does not have an exponent");
        }

        @Override
        public int getDigits(char[] digits) {
            throw new IllegalArgumentException("Exceptional value does not have digits");
        }

        @Override
        public boolean isNegative() {
            return this.isNegative;
        }

        @Override
        public boolean isExceptional() {
            return true;
        }

        @Override
        public boolean digitsRoundedUp() {
            throw new IllegalArgumentException("Exceptional value is not rounded");
        }

        @Override
        public boolean decimalDigitsExact() {
            throw new IllegalArgumentException("Exceptional value is not exact");
        }
    }
}

