/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.HeapCharBuffer;
import java.nio.ReadOnlyBufferException;

class HeapCharBufferR
extends HeapCharBuffer {
    HeapCharBufferR(int cap, int lim) {
        super(cap, lim);
        this.isReadOnly = true;
    }

    HeapCharBufferR(char[] buf, int off, int len) {
        super(buf, off, len);
        this.isReadOnly = true;
    }

    protected HeapCharBufferR(char[] buf, int mark, int pos, int lim, int cap, int off) {
        super(buf, mark, pos, lim, cap, off);
        this.isReadOnly = true;
    }

    @Override
    public CharBuffer slice() {
        return new HeapCharBufferR(this.hb, -1, 0, this.remaining(), this.remaining(), this.position() + this.offset);
    }

    @Override
    public CharBuffer duplicate() {
        return new HeapCharBufferR(this.hb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public CharBuffer put(char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(int i, char x) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(char[] src, int offset, int length) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer put(CharBuffer src) {
        throw new ReadOnlyBufferException();
    }

    @Override
    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    @Override
    String toString(int start, int end) {
        try {
            return new String(this.hb, start + this.offset, end - start);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public CharBuffer subSequence(int start, int end) {
        if (start < 0 || end > this.length() || start > end) {
            throw new IndexOutOfBoundsException();
        }
        int pos = this.position();
        return new HeapCharBufferR(this.hb, -1, pos + start, pos + end, this.capacity(), this.offset);
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

