/*
 * Java
 *
 * Copyright 2018-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothCharacteristic</code> class represents a remote or a local GATT characteristic.
 * <p>
 * Remote characteristics may be retrieved by {@link BluetoothService#getCharacteristic(int) getting the
 * characteristics} of a remote service.
 * <p>
 * Local characteristics may be retrieved by {@link BluetoothAdapter#addService(BluetoothServiceDefinition) adding a
 * local service} to the adapter.
 * <p>
 * This class provides methods to get the properties of the characteristic and to get its descriptors.
 */
public class BluetoothCharacteristic extends BluetoothAttribute {

	/**
	 * Private constructor.
	 */
	private BluetoothCharacteristic() {
		throw new RuntimeException();
	}

	/**
	 * Returns the properties of this characteristic.
	 *
	 * @return the properties of this characteristic (see {@link BluetoothProperties}).
	 */
	public byte getProperties() {
		throw new RuntimeException();
	}

	/**
	 * Returns the number of descriptors in this characteristic.
	 *
	 * @return the number of descriptors in this characteristic.
	 */
	public int getNumDescriptors() {
		throw new RuntimeException();
	}

	/**
	 * Returns the descriptor at the given index in this characteristic.
	 *
	 * @param index
	 *            the index of the descriptor.
	 * @return the descriptor at the given index.
	 * @throws IndexOutOfBoundsException
	 *             if the index is out of range ({@code index < 0 || index >= getNumDescriptors()}).
	 */
	public BluetoothDescriptor getDescriptor(int index) {
		throw new RuntimeException();
	}
}
