# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [1.4.5] - 2025-10-13

### Fixed

  - The documentation of `ej.bon.Timer.schedule` methods to clarify that changing the application time does not affect the delay of tasks scheduled using Date API.
  - The documentation of `ej.bon.Timer` to clarify that the scheduling is based on platform time, and replace the mentions of internal implementation details with more generic and clearer explanations.

### Deprecated

## [1.4.4] - 2025-02-12

### Deprecated

  - Deprecate all methods and fields from the ``ej.bon.XMath`` class that are already exposed in the ``java.lang.Math`` from EDC module. Here is the list of the remaining methods that have not been deprecated:
	- ej.bon.XMath#limit(double,double,double)
	- ej.bon.XMath#limit(float,float,float)
	- ej.bon.XMath#limit(int,int,int)
	- ej.bon.XMath#limit(long,long,longs)
	
## [1.4.3] - 2023-05-17

### Changed

  - Update `LICENSE.txt` to latest SDK/BSD license and copyright headers accordingly

## [1.4.2] - 2022-10-20

### Deprecated

  - Deprecate `Immutables.put(String, Object)` and `Immutables.putAll(Hashtable)`

### Changed

  - Improve Javadoc on Immutable objects creation

## [1.4.1] - 2022-03-14

### Changed

  - Migrate module to MMM
  - Update `LICENSE.txt` to latest ESR license 

## [1.4.0] - 2019-06-03

### Changed

  - Mark BON APIs for Null Analysis
  - Update `ej.bon.Immortals.setImmortal(Object)`, `ej.bon.Immortals.deepImmortal(Object)`, `ej.bon.ReferenceQueue` and `ej.bon.EnqueuedWeakReference` with parameterized types
  - Update `ej.bon.TimerTask.uncaughtException(Timer,Throwable)` default behavior (related to added uncaught exception handlers)
  - Mark `ej.bon.Util` methods `dynamicCodeAllowed`, `throwExceptionInThread()` and `throwHardExceptionInThread` as deprecated. These legacy APIs are not implemented. Please refer to _Kernel & Features_ specification instead (`ESR001`).
  - Update `LICENSE.txt` and file headers according to latest ESR rules
  - Update templates for `CHANGELOG.md` and `README.md`
  - Update javadoc paragraphs formatting
  
### Added

  - Add class `ej.bon.Constants` for compile-time constants access
  - Add methods for custom `ej.bon.TimerTask` uncaught exception handling at `ej.bon.Timer` instance or class level
    - `ej.bon.Timer.setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler)`
    - `ej.bon.Timer.getUncaughtExceptionHandler()` 
    - `ej.bon.Timer.setDefaultUncaughtExceptionHandler(Thread.)` 
    - `ej.bon.Timer.getDefaultUncaughtExceptionHandler()` 
  - Add method `ej.bon.Util.newArray(Class,int)` for creating arrays of references dynamically
  - Mark `Nullable` APIs
  - Add method `ej.bon.Timer.dump(PrintStream)` for debugging timers
  
### Fixed

  - Fix documentation of `ej.bon.ResourceBuffer.ResourceBuffer(String)` parameter

## [1.3.0] - 2017-07-20

### Added

  - Initial public revision with changelog.

---
_Markdown_  
_Copyright 2011-2025 MicroEJ Corp. All rights reserved._  
_This library is provided in source code for use, modification and test, subject to license terms._  
_Any modification of the source code will break MicroEJ Corp. warranties on the whole library._  