# Overview

This Android pack provides:
- the Java implementation of microvg 1.4 for Android

# Limitations

- `VectorImageBuilder` is not implemented by the ACK MicroVG implementation: all APIs throw a `RuntimeException`.
- The ACK MicroVG implementation loads vector images using Android resource identifiers. These identifiers cannot contain uppercase letters, so it is mandatory to only use lowercase characters in vector images file names, such as: `my_vector_image.xml`.
- On the VEE MicroVG implementation, the `.notdef` glyph of the font is used when the desired glyph is not included in the font. On the ACK MicroVG implementation, the `.notdef` glyph is ignored and is replaced by a default system font glyph.
- On the VEE MicroVG implementation, an exception (`VectorGraphicsException.IMAGE_OVERLAPPING_ELEMENTS`) is thrown when a `VectorImage` with overlapping elements is drawn or filtered with a transparent alpha. On the ACK MicroVG implementation, the operation is allowed.

# Usage

Add the following line to your `module.ivy`:

    <dependency org="com.microej.android.pack" name="vg-android-pack" rev="1.0.3"/>

# Requirements

- Android SDK Platform 21

Besides, the following Gradle dependencies are required in the Android Studio project:

```
runtimeOnly("androidx.core:core-animation:1.0.0-beta01")
runtimeOnly("androidx.vectordrawable:vectordrawable:1.2.0-beta01")
```

# Dependencies

_All dependencies are retrieved transitively by MicroEJ Module Manager_.

# Source

N/A.

# Restrictions

None.

---
_Copyright 2023 MicroEJ Corp. All rights reserved._  
_MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms._
