/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.http.requesthandler;

import ej.hoka.http.HttpRequest;
import ej.hoka.http.HttpResponse;

/**
 * A handler to process request and create appropriate response.
 * <p>
 * Implementations must be thread-safe to protect themselves against concurrent calls from different jobs.
 */
public interface RequestHandler {

	/**
	 * Processes the request and return the appropriate response.
	 *
	 * @param request
	 *            the {@link HttpRequest} to process.
	 * @param response
	 *            the {@link HttpResponse} to send.
	 *
	 */
	void process(final HttpRequest request, final HttpResponse response);

}
