package java.lang;

import java.security.BasicPermission;

import ej.annotation.Nullable;

/**
 * This class is for runtime permissions. A RuntimePermission contains a name (also referred to as a
 * "target name") but no actions list; you either have the named permission or you don't.
 *
 * <P>
 * The target name is the name of the runtime permission (see below). The naming convention follows
 * the hierarchical property naming convention. Also, an asterisk may appear at the end of the name,
 * following a ".", or by itself, to signify a wildcard match. For example: "loadLibrary.*" or "*"
 * is valid, "*loadLibrary" or "a*b" is not valid.
 * <P>
 * The following table lists all the possible RuntimePermission target names, and for each provides
 * a description of what the permission allows and a discussion of the risks of granting code the
 * permission.
 *
 * <table style="padding: 5; border: solid; border-spacing : 0; border-collapse : collapse;">
 * <caption style="visibility:collapse;">no_caption</caption>
 * <tr>
 * <th style="border: solid;">Permission Target Name</th>
 * <th style="border: solid;">What the Permission Allows</th>
 * <th style="border: solid;">Risks of Allowing this Permission</th>
 * </tr>
 *
 *
 * <tr>
 * <td style="border: solid;">setSecurityManager</td>
 * <td style="border: solid;">Setting of the security manager (possibly replacing an existing one)</td>
 * <td style="border: solid;">The security manager is a class that allows applications to implement a security policy.
 * Granting the setSecurityManager permission would allow code to change which security manager is
 * used by installing a different, possibly less restrictive security manager, thereby bypassing
 * checks that would have been enforced by the original security manager.</td>
 * </tr>
 *
 * <tr>
 * <td style="border: solid;">createSecurityManager</td>
 * <td style="border: solid;">Creation of a new security manager</td>
 * <td style="border: solid;">This gives code access to protected, sensitive methods that may disclose information about
 * other classes or the execution stack.</td>
 * </tr>
 * </table>
 * @see java.security.BasicPermission
 * @see java.security.Permission
 * @see java.lang.SecurityManager
 */

public final class RuntimePermission extends BasicPermission {

	/**
	 * Creates a new RuntimePermission with the specified name. The name is the symbolic name of the
	 * RuntimePermission, such as "exit", "setFactory", etc. An asterisk may appear at the end of the
	 * name, following a ".", or by itself, to signify a wildcard match.
	 *
	 * @param name
	 *        the name of the RuntimePermission.
	 *
	 * @throws NullPointerException
	 *         if <code>name</code> is <code>null</code>.
	 * @throws IllegalArgumentException
	 *         if <code>name</code> is empty.
	 */

	public RuntimePermission(String name) {
		super(name);
	}

	/**
	 * Creates a new RuntimePermission object with the specified name. The name is the symbolic name of
	 * the RuntimePermission, and the actions String is currently unused and should be null.
	 *
	 * @param name
	 *        the name of the RuntimePermission.
	 * @param actions
	 *        should be null.
	 *
	 * @throws NullPointerException
	 *         if <code>name</code> is <code>null</code>.
	 * @throws IllegalArgumentException
	 *         if <code>name</code> is empty.
	 */

	public RuntimePermission(String name, @Nullable String actions) {
		super(name, "");
	}
}
