package java.lang;

import ej.annotation.Nullable;

/**
 * {@code RuntimeException} is the superclass of those exceptions that can be thrown during the
 * normal operation of the Java Virtual Machine.
 *
 * <p>
 * {@code RuntimeException} and its subclasses are <em>unchecked exceptions</em>. Unchecked
 * exceptions do <em>not</em> need to be declared in a method or constructor's {@code throws} clause
 * if they can be thrown by the execution of the method or constructor and propagate outside the
 * method or constructor boundary.
 */
public class RuntimeException extends Exception {

	/**
	 * Constructs a new runtime exception with {@code null} as its detail message. The cause is not
	 * initialized, and may subsequently be initialized by a call to {@link #initCause}.
	 */
	public RuntimeException() {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new runtime exception with the specified detail message. The cause is not
	 * initialized, and may subsequently be initialized by a call to {@link #initCause}.
	 *
	 * @param message
	 *        the detail message. The detail message is saved for later retrieval by the
	 *        {@link #getMessage()} method.
	 */
	public RuntimeException(String message) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new runtime exception with the specified detail message and cause.
	 * <p>
	 * Note that the detail message associated with {@code cause} is <i>not</i> automatically
	 * incorporated in this runtime exception's detail message.
	 *
	 * @param message
	 *        the detail message (which is saved for later retrieval by the {@link #getMessage()}
	 *        method).
	 * @param cause
	 *        the cause (which is saved for later retrieval by the {@link #getCause()} method). (A
	 *        <code>null</code> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public RuntimeException(String message, @Nullable Throwable cause) {
		throw new RuntimeException();
	}

	/**
	 * Constructs a new runtime exception with the specified cause and a detail message of
	 * <code>(cause==null ? null : cause.toString())</code> (which typically contains the class and detail
	 * message of <code>cause</code>). This constructor is useful for runtime exceptions that are little
	 * more than wrappers for other throwables.
	 *
	 * @param cause
	 *        the cause (which is saved for later retrieval by the {@link #getCause()} method). (A
	 *        <code>null</code> value is permitted, and indicates that the cause is nonexistent or unknown.)
	 */
	public RuntimeException(@Nullable Throwable cause) {
		throw new RuntimeException();
	}

}
