/*
 * Java
 *
 * 2019-2022 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.sni;

import java.io.PrintStream;

import ej.annotation.Nullable;

/**
 * A {@link NativeResource} is an object representing a runtime element managed by the native side (such as a file, a
 * socket, an image, ...).
 * <p>
 *
 * A {@link NativeResource} is registered using the C function <code>SNI_registerResource()</code> and unregistered
 * using the C function <code>SNI_unregisterResource()</code>. {@link NativeResource} can be listed using the
 * {@link #listRegisteredNativeResources()} method.
 */
final public class NativeResource {

	private NativeResource() {
		throw new RuntimeException();
	}

	/**
	 * Gets an object representing the owner of the resource.
	 *
	 * @return an object representing the owner of the resource.
	 */
	public Object getOwner() {
		throw new RuntimeException();
	}

	/**
	 * Gets the integer value of the resource pointer given to <code>SNI_registerResource()</code>.
	 *
	 * @return the integer value of the resource pointer given to <code>SNI_registerResource()</code>.
	 */
	public long getId() {
		throw new RuntimeException();
	}

	/**
	 * Gets a string describing this resource.
	 *
	 * @return a string describing this resource.
	 */
	public String getDescription() {
		throw new RuntimeException();
	}

	/**
	 * Registers the given native resource to be closed automatically when the given object is garbage collected.
	 * <p>
	 * The native resource is identified by the pair <code>resource</code>, <code>closeFunction</code>.
	 * <p>
	 * The native resource must have been registered previously in C using the SNI function
	 * <code>SNI_registerResource()</code>. If later the native resource is explicitly closed using the SNI function
	 * <code>SNI_unregisterResource()</code> then the automatic close configuration is cancelled.
	 * <p>
	 * At most one object can be registered for the given native resource. The same object can be registered for several
	 * native resources.
	 *
	 * @param resource
	 *            the <code>resource</code> argument given to <code>SNI_registerResource()</code> when the native
	 *            resource has been registered.
	 * @param closeFunction
	 *            the <code>close</code> argument given to <code>SNI_registerResource()</code> when the native resource
	 *            has been registered.
	 * @param obj
	 *            when this object is garbage collected, the native resource is closed.
	 *
	 * @throws IllegalArgumentException
	 *             if the given native resource is not registered or if {@link #closeOnGC(long, long, Object)} has
	 *             already been called for the given native resource.
	 * @throws NullPointerException
	 *             if <code>obj</code> is null.
	 */
	public static void closeOnGC(long resource, long closeFunction, Object obj) {
		throw new RuntimeException();
	}

	/**
	 * Cancels an automatic close configuration done previously with {@link #closeOnGC(long, long, Object)}.
	 * <p>
	 * This method doesn't need to be called if the native resource will be closed using the SNI function
	 * <code>SNI_unregisterResource()</code>.
	 *
	 * @param resource
	 *            the <code>resource</code> argument given to {@link #closeOnGC(long, long, Object)}.
	 * @param closeFunction
	 *            the <code>closeFunction</code> argument given to {@link #closeOnGC(long, long, Object)}.
	 *
	 * @return the object that has been passed to {@link #closeOnGC(long, long, Object)} or null if no automatic close
	 *         is configured for the given native resource or if the object has been garbage collected.
	 *
	 * @throws IllegalArgumentException
	 *             if the given native resource is not registered or has already been closed.
	 */
	@Nullable
	public static Object clearCloseOnGC(long resource, long closeFunction) {
		throw new RuntimeException();
	}

	/**
	 * Gets the list of registered native resources.
	 * <p>
	 * A native resources is registered using the C function <code>SNI_registerResource()</code>.
	 *
	 * @return an {@link Iterable} of registered {@link NativeResource} objects.
	 */
	public static Iterable<NativeResource> listRegisteredNativeResources() {
		throw new RuntimeException();
	}

	/**
	 * Prints a description of the registered native resources to the specified print stream.
	 * <p>
	 * A native resources is registered using the C function <code>SNI_registerResource()</code>.
	 *
	 * @param out
	 *            {@code PrintStream} to use for output.
	 */
	public static void printRegisteredNativeResources(PrintStream out) {
		throw new RuntimeException();
	}

	/**
	 * Gets the number of registered native resources.
	 *
	 * @return the number of registered native resources.
	 */
	public static int getRegisteredNativeResourcesCount() {
		throw new RuntimeException();
	}

	/**
	 * Gets the native resource registered with the given <code>resource</code> and <code>closeFunction</code> pair.
	 * <p>
	 *
	 * @param resource
	 *            the <code>resource</code> argument given to <code>SNI_registerResource()</code> when the native
	 *            resource has been registered.
	 * @param closeFunction
	 *            the <code>close</code> argument given to <code>SNI_registerResource()</code> when the native resource
	 *            has been registered.
	 *
	 * @return a {@link NativeResource} or null if no {@link NativeResource} has been registered for the given
	 *         <code>resource</code> and <code>closeFunction</code> pair.
	 */
	@Nullable
	public static NativeResource getNativeResource(long resource, long closeFunction) {
		throw new RuntimeException();
	}
}
