/*
 * Java
 *
 * Copyright 2019 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import ej.rcommand.synchronous.RemoteCommandClient;

/**
 * The <code>RemoteNotificationListener</code> class handles the notifications sent by a {@link RemoteCommandManager} to
 * the {@link RemoteCommandClient}. Notifications may be sent by the manager without any action from the client and do
 * not expect a response or an acknowledgment.
 */
public interface RemoteNotificationListener {

	/**
	 * Returns the name of the notification managed by this listener.
	 *
	 * @return the name of the notification managed by this listener.
	 */
	String getName();

	/**
	 * Handles the notification. The body of the notification may be read by using the given command reader.
	 *
	 * @param commandReader
	 *            the command reader to use to read the notification body.
	 */
	void notificationReceived(CommandReader commandReader);
}
