/*
 * Java
 *
 * Copyright 2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.hoka.http;

import static ej.hoka.http.HttpConstants.HTTP_STATUS_OK;

/**
 * Stop a request processing
 */
class HaltException extends RuntimeException {

	private static final long serialVersionUID = 1L;

	private final String status;
	private final String body;

	/**
	 *
	 */
	HaltException() {
		super(null, null);
		this.status = HTTP_STATUS_OK;
		this.body = ""; //$NON-NLS-1$ // NOSONAR
	}

	/**
	 * @param status
	 *            http status
	 *
	 */
	HaltException(final String status) {
		super(null, null);
		this.status = status;
		this.body = ""; //$NON-NLS-1$ // NOSONAR
	}

	/**
	 * @param status
	 *            http status
	 * @param body
	 *            error message
	 */
	HaltException(String status, String body) {
		super(null, null);
		this.status = status;
		this.body = body;
	}

	/**
	 * Gets the status.
	 *
	 * @return the status.
	 */
	public String getStatus() {
		return this.status;
	}

	/**
	 * Gets the body.
	 *
	 * @return the body.
	 */
	public String getBody() {
		return this.body;
	}

}
