/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.tool.addon.util;

/**
 * A MessageLogger is used to log messages.
 * <p>
 * Where the messages are logged is depending on the implementation.
 *
 */
public interface MessageLogger {
	/**
	 * Logs a message at the given level.
	 * <p>
	 * <code>level</code> constants are defined in the {@link Message} class.
	 * </p>
	 *
	 * @param msg
	 *            the message to log
	 * @param level
	 *            the level at which the message should be logged.
	 * @see Message#MSG_DEBUG
	 * @see Message#MSG_VERBOSE
	 * @see Message#MSG_INFO
	 * @see Message#MSG_WARN
	 * @see Message#MSG_ERR
	 */
	void log(String msg, int level);

	void debug(String msg);

	void verbose(String msg);

	void info(String msg);

	void warn(String msg);

	void error(String msg);

}
