package ej.ecom.io;

import java.io.IOException;

public interface DatagramConnection extends Connection {

	public abstract int getMaximumLength() throws IOException;

	public abstract int getNominalLength() throws IOException;

	public abstract Datagram newDatagram(byte[] buf, int size) throws IOException;

	public abstract Datagram newDatagram(int size) throws IOException;

	public abstract Datagram newDatagram(byte[] buf, int size, String addr) throws IOException;

	public abstract Datagram newDatagram(int size, String addr) throws IOException;

	public abstract void receive(Datagram dgram) throws IOException;

	public abstract void send(Datagram dgram) throws IOException;
}