/*
 * Java
 *
 * Copyright 2017-2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 */
package ej.junit;

public interface TestListener {

	void testBeforeClassMethod(String testClass, String methodName);

	void testInstance(String testClass);

	void testBeforeMethod(String testClass, String methodName);

	void testAfterMethod(String testClass, String methodName);

	void testAfterClassMethod(String testClass, String methodName);

	void onSuiteStart(String name);

	void onSuiteEnd(String name, int runs, int failures, int errors);

	void onCaseStart(String name, String className, String file, int line);

	void onCaseEnd(String name, double duration);

	void onFailure(String message, String type, String trace);

	void onError(String message, String type, String trace);

	void onSkip(String message);

}
