/*
 * Java
 *
 * Copyright 2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.tool.ui.generator;

import java.io.BufferedInputStream;

/**
 * Represents an image listed in a ".images.list" file. This image has to be
 * converted in a binary format according the specified output format (see
 * {@link #getOutputFormat()} and the output format options (see
 * {@link #getOptions()}).
 */
public interface Image {

	/**
	 * Returns a new {@link BufferedInputStream} on the image.
	 * <p>
	 * First bytes can be read even if caller (implementation of
	 * {@link ImageConverter} is not able to decode the image (often the first image
	 * bytes must be read to know if the loader is able to decode the image).
	 *
	 * @return a new {@link BufferedInputStream} on the image.
	 */
	BufferedInputStream getInputData();

	/**
	 * Returns the format specified in ".images.list" file. More specifically, this
	 * format is the upper-case string of the format specified in list file.
	 * <p>
	 * Returns an empty string when the format is not specified.
	 *
	 * @return the expected image output format.
	 */
	String getOutputFormat();

	/**
	 * Returns the options specified in ".images.list" file. Case is respected.
	 * <p>
	 * Returns an empty array when no option is specified.
	 *
	 * @return the output format options.
	 */
	String[] getOptions();
}
