/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display.transform;

import ej.microui.display.GraphicsContext;
import ej.microui.display.Renderable;

/**
 * This class holds a context in order to perform a free rotation (0 to 360 degrees) on a renderable. The rotation is
 * specified by the center and the angle. The reference point is the renderable top-left corner. The rotation point is
 * relative to the current translation of the graphics context where the renderable will be drawn. The renderable anchor
 * point is relative to the same translation and to the given alignment.
 * <p>
 * To rotate a renderable on itself, use the following lines:
 * <p>
 * <code>
 * int rx = x + renderable.getWidth() / 2;<br>
 * int ry = y + renderable.getHeight() / 2;<br>
 * rotation.setRotationCenter(rx, ry);<br>
 * rotation.setAngle(78);<br>
 * rotation.draw(gc, renderable, rx, ry, GraphicsContext.HCENTER | GraphicsContext.VCENTER);<br>
 * </code>
 * <p>
 * To rotate a renderable around a circle, use the following lines:
 * <p>
 * <code>
 * rotation.setRotationCenter(rx, ry);<br>
 * for (int i = 0; i &lt; 360; i += 45) {<br>
 * 	rotation.setAngle(i);<br>
 *  rotation.draw(gc, renderable, rx - diameter / 2, ry - diameter / 2,<br>
 *  	GraphicsContext.TOP | GraphicsContext.LEFT);<br>
 * }<br>
 * </code>
 *
 * @since 2.4
 */
public class Rotate extends AbstractTransform {

	/**
	 * Returns the current rotation angle.
	 *
	 * @return the current rotation angle.
	 */
	public int getAngle() {
		throw new RuntimeException();
	}

	/**
	 * Sets the new rotation angle.
	 *
	 * @param angle
	 *            the new rotation angle
	 */
	public void setAngle(int angle) {
		throw new RuntimeException();
	}

	/**
	 * Sets the new rotation center coordinates.
	 *
	 * @param x
	 *            the x coordinate
	 * @param y
	 *            the y coordinate
	 */
	public void setRotationCenter(int x, int y) {
		throw new RuntimeException();
	}

	/**
	 * Returns the current X coordinate.
	 *
	 * @return the current X coordinate.
	 */
	public int getRotationX() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current Y coordinate.
	 *
	 * @return the current Y coordinate.
	 */
	public int getRotationY() {
		throw new RuntimeException();
	}

	/**
	 * Draws the renderable applying the current rotation. This method uses the <code>bilinear</code> algorithm to
	 * render the renderable. This algorithm performs better rendering than <code>nearest neighbor</code> algorithm but
	 * it is slower to apply.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where to render the drawing.
	 * @param renderable
	 *            the {@link Renderable} to draw.
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 * @throws NullPointerException
	 *             if @{code image} or @{code gc} is @{code null}
	 * @throws IllegalArgumentException
	 *             if <code>anchor</code> is not a valid value (<code>BASELINE</code> is illegal).
	 * @throws UnsupportedOperationException
	 *             when the renderable cannot be rotated (not implemented)
	 * @see #drawNearestNeighbor(GraphicsContext, Renderable, int, int, int)
	 */
	public void drawBilinear(GraphicsContext gc, Renderable renderable, int x, int y, int anchor) {
		throw new RuntimeException();
	}

	/**
	 * Draws the renderable applying the current rotation. This method uses the <code>nearest neighbor</code> algorithm
	 * to render the conent. This algorithm is faster than <code>bilinear</code> algorithm but its rendering is more
	 * simple.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param renderable
	 *            the {@link Renderable} to draw.
	 * @param x
	 *            the x coordinate of the image reference anchor point
	 * @param y
	 *            the y coordinate of the image reference anchor point
	 * @param anchor
	 *            position of the image reference point around the anchor point
	 * @throws NullPointerException
	 *             if @{code image} or @{code gc} is @{code null}
	 * @throws IllegalArgumentException
	 *             if <code>anchor</code> is not a valid value (<code>BASELINE</code> is illegal).
	 * @throws UnsupportedOperationException
	 *             when the renderable cannot be rotated (not implemented)
	 * @see #drawBilinear(GraphicsContext, Renderable, int, int, int)
	 */
	public void drawNearestNeighbor(GraphicsContext gc, Renderable renderable, int x, int y, int anchor) {
		throw new RuntimeException();
	}
}
