/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display.shape;

import ej.microui.display.GraphicsContext;

/**
 * The {@link ThickShapes} class offers advanced drawing facilities, to render thick lines, circles etc. <br>
 * <br>
 * A {@link ThickShapes} instance holds a global state (thickness) for all drawings. Several {@link ThickShapes}
 * instances can be created at same time. However a default instance is created by MicroUI framework and is always
 * available.<br>
 *
 * @since 2.3
 */
public class ThickShapes {

	/**
	 * Default {@link ThickShapes} instance.
	 */
	public static ThickShapes Singleton = new ThickShapes();

	private int thickness;

	/**
	 * Creates a new {@link ThickShapes} instance. The global state is set to its initial value.
	 *
	 * @see #reset()
	 */
	public ThickShapes() {
		throw new RuntimeException();
	}

	/**
	 * Resets the {@link ThickShapes} global state to its initial values. Default <code>thickness</code> is 1.
	 */
	public void reset() {
		throw new RuntimeException();
	}

	/**
	 * Returns the current <code>thickness</code>.
	 *
	 * @return the current <code>thickness</code>.
	 */
	public int getThickness() {
		throw new RuntimeException();
	}

	/**
	 * Apply a new <code>thickness</code>.
	 *
	 * @param thickness
	 *            the new thickness to apply.
	 * @throws IllegalArgumentException
	 *             when given thickness is negative
	 */
	public void setThickness(int thickness) {
		throw new RuntimeException();
	}

	/**
	 * Draws a line from <code>(x1,y1)</code> to <code>(x2,y2)</code> using the {@link GraphicsContext}'s current color.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x1
	 *            the x coordinate of the start of the line.
	 * @param y1
	 *            the y coordinate of the start of the line.
	 * @param x2
	 *            the x coordinate of the end of the line.
	 * @param y2
	 *            the y coordinate of the end of the line.
	 */
	public void drawLine(GraphicsContext gc, int x1, int y1, int x2, int y2) {
		throw new RuntimeException();
	}

	/**
	 * Draws the outline of a circle covering the rectangle specified by its diameter, using the {@link GraphicsContext}
	 * 's current color.<br>
	 * <br>
	 * The center of the circle is defined as the center of the rectangle whose origin is at <code>(x,y)</code>
	 * (upper-left corner) and whose dimension is given by <code>diameter</code>.<br>
	 * <br>
	 * If <code>diameter</code> is negative, nothing is drawn.<br>
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x
	 *            the x coordinate of the upper-left corner of the rectangle where the circle is drawn.
	 * @param y
	 *            the y coordinate of the upper-left corner of the rectangle where the circle is drawn.
	 * @param diameter
	 *            the diameter of the circle to draw.
	 */
	public void drawCircle(GraphicsContext gc, int x, int y, int diameter) {
		throw new RuntimeException();
	}

	/**
	 * Draws the outline of a circular arc covering the specified square, using the {@link GraphicsContext} 's current
	 * color.<br>
	 * <br>
	 * The arc is drawn from <code>startAngle</code> up to <code>arcAngle</code> degrees. The center of the arc is
	 * defined as the center of the rectangle whose origin is at <code>(x,y)</code> (upper-left corner) and whose
	 * dimension is given by <code>diameter</code>.<br>
	 * <br>
	 * Angles are interpreted such that 0 degrees is at the 3 o'clock position. A positive value indicates a
	 * counter-clockwise rotation while a negative value indicates a clockwise rotation.<br>
	 * <br>
	 * If <code>diameter</code> is negative, nothing is drawn.
	 *
	 * @param gc
	 *            the {@link GraphicsContext} where render the drawing.
	 * @param x
	 *            the x coordinate of the upper-left corner of the rectangle where the arc is drawn.
	 * @param y
	 *            the y coordinate of the upper-left corner of the rectangle where the arc is drawn.
	 * @param diameter
	 *            the diameter of the arc to draw.
	 * @param startAngle
	 *            the beginning angle of the arc to draw.
	 * @param arcAngle
	 *            the angular extent of the arc from <code>startAngle</code>.
	 */
	public void drawCircleArc(GraphicsContext gc, int x, int y, int diameter, int startAngle, int arcAngle) {
		throw new RuntimeException();
	}

}
