/*
 * Java
 *
 * Copyright 2018-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothStatus</code> class enumerates the values for error codes of ATT requests.
 * <p>
 * Refer to «Core Specification Vol 3, Part F, 3.4.1.1 Error Response» and to «Core Specification Supplement Part B, 1.2
 * List of error codes».
 */
public class BluetoothStatus {

	/** OK. */
	public static final byte OK = 0x00;

	/** Invalid handle. */
	public static final byte INVALID_HANDLE = 0x01;

	/** Read not permitted. */
	public static final byte READ_NOT_PERMITTED = 0x02;

	/** Write not permitted. */
	public static final byte WRITE_NOT_PERMITTED = 0x03;

	/** Invalid PDU. */
	public static final byte INVALID_PDU = 0x04;

	/** Insufficient authentication. */
	public static final byte INSUFFICIENT_AUTHENTICATION = 0x05;

	/** Request not supported. */
	public static final byte REQUEST_NOT_SUPPORTED = 0x06;

	/** Invalid offset. */
	public static final byte INVALID_OFFSET = 0x07;

	/** Insufficient authorization. */
	public static final byte INSUFFICIENT_AUTHORIZATION = 0x08;

	/** Prepare queue full. */
	public static final byte PREPARE_QUEUE_FULL = 0x09;

	/** Attribute not found. */
	public static final byte ATTRIBUTE_NOT_FOUND = 0x0A;

	/** Attribute not long. */
	public static final byte ATTRIBUTE_NOT_LONG = 0x0B;

	/** Insufficient key size. */
	public static final byte INSUFFICIENT_KEY_SIZE = 0x0C;

	/** Invalid value length. */
	public static final byte INVALID_VALUE_LENGTH = 0x0D;

	/** Unlikely. */
	public static final byte UNLIKELY = 0x0E;

	/** Insufficient encryption. */
	public static final byte INSUFFICIENT_ENCRYPTION = 0x0F;

	/** Unsupported group type. */
	public static final byte UNSUPPORTED_GROUP_TYPE = 0x10;

	/** Insufficient resources. */
	public static final byte INSUFFICIENT_RESOURCES = 0x11;

	/** Write request rejected. */
	public static final byte WRITE_REQUEST_REJECTED = (byte) 0xFC;

	/** CCC descriptor improperly configured. */
	public static final byte CCC_DESCRIPTOR_IMPROPERLY_CONFIGURED = (byte) 0xFD;

	/** Procedure already in progress. */
	public static final byte PROCEDURE_ALREADY_IN_PROGRESS = (byte) 0xFE;

	/** Out of range. */
	public static final byte OUT_OF_RANGE = (byte) 0xFF;

	/**
	 * Private constructor.
	 */
	private BluetoothStatus() {
		throw new RuntimeException();
	}
}
