/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.framework.services;

import ej.microvg.VectorFont;

/**
 * This service allows Features to get fonts.
 */
public interface FontService {

	/**
	 * Returns the regular font.
	 *
	 * @return the regular font.
	 */
	VectorFont getRegularFont();

	/**
	 * Returns the bold italic font.
	 *
	 * @return the bold italic font.
	 */
	VectorFont getBoldItalicFont();

	/**
	 * Returns the light font.
	 *
	 * @return the light font.
	 */
	VectorFont getLightFont();
}
