/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.notifications;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.BluetoothHost;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.RemoteNotificationListener;

public class EventNotificationListener implements RemoteNotificationListener {

	@Override
	public String getName() {
		return Commands.BLUETOOTH_EVENT;
	}

	@Override
	public void notificationReceived(CommandReader commandReader) {
		try {
			byte[] event = commandReader.readByteArray();
			BluetoothHost.getInstance().pushEvent(event);
		} catch (IOException e) {
			// ignore this exception
		}
	}
}
