/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

/**
 * The <code>BluetoothPermissions</code> interface enumerates the values for attribute permissions.
 * <p>
 * A read flag and a write flag may be combined to create a set of permissions.
 * <p>
 * Attribute permissions are checked when a client wants to access an attribute. The permissions are only used by the
 * server and they are not sent to the client.
 * <p>
 * Refer to «Core Vol 3, Part F, 3.2.5 Attribute Permissions».
 */
public interface BluetoothPermissions {

	/** No access. */
	int NONE = 0x00;

	/** Read access, no encryption required. **/
	int READ = 0x01;
	/** Read access, encryption required. **/
	int READ_ENCRYPT = 0x02;
	/** Read access, authentication required. **/
	int READ_AUTH = 0x04;

	/** Write access, no encryption required. **/
	int WRITE = 0x08;
	/** Write access, encryption required. **/
	int WRITE_ENCRYPT = 0x10;
	/** Write access, authentication required. **/
	int WRITE_AUTH = 0x20;

	/** Read and write access, no encryption required. **/
	int RW = READ | WRITE;
	/** Read and write access, encryption required. **/
	int RW_ENCRYPT = READ_ENCRYPT | WRITE_ENCRYPT;
	/** Read and write access, authentication required. **/
	int RW_AUTH = READ_AUTH | WRITE_AUTH;
}
