/*
 * C
 *
 * Copyright 2023-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */

/* Includes ------------------------------------------------------------------*/

#include "LLDEVICE_impl.h"
#include <stdio.h>
#include <string.h>

#include <sni.h>

#define ID_LENGTH 8

uint8_t LLDEVICE_IMPL_getArchitecture(uint8_t* buffer, int32_t length) {
	uint8_t result = 4;

	if (length < 4) {
		result = 0;
	} else {
		buffer[0]= 'N';
		buffer[1]= 'X';
		buffer[2]= 'P';
		buffer[3]= 0;
	}

	return result;
}

uint32_t LLDEVICE_IMPL_getId(uint8_t* buffer, int32_t length) {
	uint32_t result = ID_LENGTH;

	if (length < ID_LENGTH) {
		result = 0;
	} else {
		buffer[0] = 0x18;
		buffer[1] = 0xE9;
		buffer[2] = 0xA7;
		buffer[3] = 0x38;
		buffer[4] = 0x2B;
		buffer[5] = 0x52;
		buffer[6] = 0xAC;
		buffer[7] = 0x8D;
	}

	return result;
}
