/*
 * Java
 *
 * Copyright 2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.control.fs;

/**
 * Exception thrown when the limit of the number of opened files is exceeded.
 */
public class OpenedFilesLimitException extends SecurityException {

	private static final long serialVersionUID = -6852081546561586687L;

	/**
	 * Constructs a new exception with {@code null} as its detail message. The cause is not initialized, and may
	 * subsequently be initialized by a call to {@link #initCause}.
	 */
	public OpenedFilesLimitException() {
		super();
	}
}
