/*
 * Copyright (c) 1996, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2021-2022, MicroEJ Corp. This file has been modified by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package java.security;

/**
 * This class is a simple holder for a key pair (a public key and a private key). It does not enforce any security, and,
 * when initialized, should be treated like a PrivateKey.
 *
 * @see PublicKey
 * @see PrivateKey
 *
 * @author Benjamin Renaud
 */

public final class KeyPair implements java.io.Serializable {

	private static final long serialVersionUID = -7565189502268009837L;

	/**
	 * Constructs a key pair from the given public key and private key.
	 *
	 * <p>
	 * Note that this constructor only stores references to the public and private key components in the generated key
	 * pair. This is safe, because {@code Key} objects are immutable.
	 *
	 * @param publicKey
	 *            the public key.
	 *
	 * @param privateKey
	 *            the private key.
	 */
	public KeyPair(PublicKey publicKey, PrivateKey privateKey) {
		throw new RuntimeException();
	}

	/**
	 * Returns a reference to the public key component of this key pair.
	 *
	 * @return a reference to the public key.
	 */
	public PublicKey getPublic() {
		throw new RuntimeException();
	}

	/**
	 * Returns a reference to the private key component of this key pair.
	 *
	 * @return a reference to the private key.
	 */
	public PrivateKey getPrivate() {
		throw new RuntimeException();
	}
}
