/*
 * Java
 *
 * Copyright 2019 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.net.util.connectivity;

import android.net.ConnectivityManager.NetworkCallback;
import android.net.Network;
import android.net.NetworkCapabilities;

/**
 * A simple network call back.
 */
public interface SimpleNetworkCallback {

	/**
	 * Called when the Internet state change.
	 *
	 * @param hasInternet
	 *            <code>true</code> if Internet access is available.
	 * @see NetworkCallback#onCapabilitiesChanged(Network, NetworkCapabilities)
	 */
	void onInternet(boolean hasInternet);

	/**
	 * Called when the connectivity state changes.
	 *
	 * @param isConnected
	 *            <code>true</code> if a network is available.
	 * @see NetworkCallback#onAvailable(Network)
	 * @see NetworkCallback#onLost(Network)
	 */
	void onConnectivity(boolean isConnected);
}
