/*
 * Java
 *
 * Copyright 2014-2021 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.sni;


/**
 * A pool of resources where resources are allocated at creation time (no lazy allocation).
 */
public abstract class PoolOfLimitedReusableResources extends PoolOfReusableResources {

	/**
	 * Allocate a new pool of resources
	 *
	 * @param maxNbResources 0 (i.e. unlimited) is not allowed.
	 * @param allocationSize size of allocated resources (in bytes). 0 (i.e. unlimited) is not allowed.
	 */
	public PoolOfLimitedReusableResources(int maxNbResources, int allocationSize) {
		super(maxNbResources);
		throw new RuntimeException();
	}

	/**
	 * Return size of allocated resources (in bytes).
	 * @return size of allocated resources (in bytes).
	 */
	public int getAllocationSize() {
		throw new RuntimeException();
	}

}
