/*
 * 2011-2019 ESR - Not subject to Copyright.
 *
 * This document has been released and published by E-S-R consortium, a non-profit entity.
 * To learn more about E-S-R consortium, please visit http://www.e-s-r.net/.
 * The matter contained in this document is not subject to copyright; you are free to use it for any purpose, for more information see E-S-R consortium policies.
 */
package ej.bon;

import java.lang.ref.WeakReference;

import ej.annotation.Nullable;

/**
 * EnqueuedWeakReference are objects that are queued in an ReferenceQueue by the
 * system when the object they point at (see
 * {@link java.lang.ref.Reference#get()}) is set to <code>null</code> by the
 * system. A typical use is to subclass <code>EnqueuedWeakReference</code> with
 * classes that hold native handles that need to be freed at the native level.
 * 
 * @param <T>
 *            the type of enqueued objects
 */
public class EnqueuedWeakReference<T> extends WeakReference<T> {

	/**
	 * Creates a new <code>EnqueuedWeakReference</code>.
	 * <p>
	 * The given reference can be retrieved using {@link #get()} until the object is
	 * garbage collected. Then the method will return <code>null</code>.
	 *
	 * @param ref
	 *            object the new weak reference will refer to
	 * @param queue
	 *            the queue with which the reference is to be registered
	 */
	public EnqueuedWeakReference(T ref, @Nullable ReferenceQueue<? super T> queue) {
		super(null);
		throw new RuntimeException();
	}
}