/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.image.pathdata;

import java.io.ByteArrayOutputStream;

/**
 * Encodes a path whose data is stored in only one byte array: CMD0, CMD_DATA0, CMD_DATA1, CMD1, CMD_DATA0, CMD_DATA1,
 * etc. The command and command's attributes are encoded in float or signed 8-16-32 bits.
 */
public abstract class SingleArrayPathData implements PathData {

	private final ByteArrayOutputStream buffer;

	/**
	 * Creates an encoder that will encode the path data in a single byte array.
	 */
	protected SingleArrayPathData() {
		this.buffer = new ByteArrayOutputStream();
	}

	@Override
	public void reset() {
		this.buffer.reset();
	}

	/**
	 * Adds a byte in the single path data buffer.
	 *
	 * @param b
	 *            the byte to add
	 */
	protected void write(byte b) {
		this.buffer.write(b);
	}

	/**
	 * Gets the buffer that contains the encoded data of the path.
	 *
	 * @return the encoded data
	 */
	public byte[] getPath() {
		return this.buffer.toByteArray();
	}
}
