/*
 * Copyright 2016-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector;

import ej.annotation.Nullable;
import ej.mwt.Widget;

/**
 * An universal selector selects all widgets.
 * <p>
 * Equivalent to <code>*</code> selector in CSS. Its specificity is (0,0,0,0).
 *
 * @see SelectorHelper
 */
public class UniversalSelector implements Selector {

	/**
	 * Universal selector singleton to avoid creating several ones.
	 */
	public static final UniversalSelector UNIVERSAL_SELECTOR = new UniversalSelector();

	/**
	 * Creates an universal selector.
	 */
	private UniversalSelector() {
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		return true;
	}

	@Override
	public int getSpecificity() {
		return SelectorHelper.getSpecificity(0, 0, 0, 0);
	}

	@Override
	public boolean equals(@Nullable Object obj) {
		return (obj == this);
	}

	@Override
	public int hashCode() {
		return 0;
	}
}
