/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg.paint;

import java.awt.Color;
import java.awt.Paint;

/**
 * Represents a path painter with a ARGB color.
 */
public class VGColor implements VGPaint {

	/**
	 * The ARGB color.
	 */
	private final int color;

	/**
	 * Creates a color painter over the given color.
	 *
	 * @param color
	 *            a ARGB color
	 */
	public VGColor(int color) {
		this.color = color;
	}

	@Override
	public VGPaint apply(PaintVisitor visitor) {
		return new VGColor(visitor.visitColor(this.color));
	}

	@Override
	public Paint getPaint() {
		return new Color(this.color, true);
	}

}
