/*
 * Java
 *
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microvg;

/**
 * This decoder allows to retrieve a MicroVG path command from an encoded command for a given GPU.
 */
public interface CommandDecoder {

	/**
	 * Decodes the command encoded for a GPU.
	 *
	 * @param command
	 *            the command to decode.
	 * @return a MicroVG command.
	 */
	int decodeCommand(int command);
}
