/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.bluetooth.BluetoothAdapter;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class StopScanningEndpoint implements Endpoint {

	@Override
	public String getName() {
		return Commands.BLUETOOTH_STOP_SCANNING;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		// do nothing
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		if (BluetoothAdapter.getAdapter().stopScanning()) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
