/*
 * Java
 *
 * Copyright 2023 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.time.zone;

import java.time.ZoneId;
import java.util.HashSet;
import java.util.NavigableMap;
import java.util.Set;

/**
 * The default provider for timezone-rules when no other provider has been set.
 * <p>
 * This provider specifies for the "GMT" zone only.
 */
class DefaultZoneRulesProvider extends ZoneRulesProvider {

	private static final String GMT = "GMT";
	
	@Override
	protected Set<String> provideZoneIds() {
		Set<String> set = new HashSet<>(1);
		set.add(GMT);
		return set;
	}

	@Override
	protected ZoneRules provideRules(String zoneId, boolean forCaching) {
		if (GMT.equals(zoneId)) {
			return ZoneId.of(GMT).getRules();
		}
		throw new ZoneRulesException("Unknown time-zone ID: " + zoneId);
	}

	@Override
	protected NavigableMap<String, ZoneRules> provideVersions(String zoneId) {
		throw new ZoneRulesException("No history available for this zone ID " + zoneId);
	}

}
