/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.annotation.Nullable;
import ej.bluetooth.BluetoothAdapter;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Endpoint;

public class StartAdvertisingEndpoint implements Endpoint {

	private @Nullable byte[] advertisementData;

	@Override
	public String getName() {
		return Commands.BLUETOOTH_START_ADVERTISING;
	}

	@Override
	public void readRequestBody(CommandReader reader) throws IOException {
		this.advertisementData = reader.readByteArray();
	}

	@Override
	public void writeResponseBody(CommandSender sender) throws IOException {
		byte[] advertisementData = this.advertisementData;
		assert (advertisementData != null);
		if (BluetoothAdapter.getAdapter().startAdvertising(advertisementData)) {
			sender.sendInt(Commands.OK);
		} else {
			sender.sendInt(Commands.ERROR);
		}
	}
}
