/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Short}. This converter creates a clone of the original {@link Short}.
 */
public class ShortConverter implements Converter<Short> {

	@Override
	public Short convert(Short arg0, Feature targetOwner) throws IllegalAccessError {
		final short value = arg0.shortValue();
		RunnableWithResult<Short> runnable = new RunnableWithResult<Short>() {
			@Override
			public Short runWithResult() {
				return new Short(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Short> getType() {
		return Short.class;
	}

}