/*
 * Java
 *
 * Copyright 2019-2024 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.notifications;

import ej.library.iot.rcommand.bluetooth.BluetoothHost;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.RemoteNotificationListener;

public class EventAvailableNotificationListener implements RemoteNotificationListener {

	@Override
	public String getName() {
		return Commands.BLUETOOTH_EVENT_AVAILABLE;
	}

	@Override
	public void notificationReceived(CommandReader commandReader) {
		BluetoothHost.getInstance().onEventAvailable();
	}
}
