/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.basic;

import ej.annotation.Nullable;
import ej.microui.event.Event;
import ej.microui.event.generator.Buttons;
import ej.mwt.event.DesktopEventGenerator;
import ej.widget.basic.Label;
import ej.widget.basic.OnClickListener;

public class Button
extends Label {
    public static final int ACTIVE = 1;
    @Nullable
    private OnClickListener onClickListener = null;
    private boolean pressed = false;

    public Button() {
        this("");
    }

    public Button(String text) {
        super(text, true);
    }

    public void setOnClickListener(@Nullable OnClickListener listener) {
        this.onClickListener = listener;
    }

    public boolean isInState(int state) {
        return state == 1 && this.pressed || super.isInState(state);
    }

    public boolean handleEvent(int event) {
        int action;
        int type = Event.getType((int)event);
        if (type == 2) {
            int action2 = Buttons.getAction((int)event);
            if (action2 == 0) {
                this.setPressed(true);
            } else if (action2 == 1) {
                this.setPressed(false);
                this.handleClick();
                return true;
            }
        } else if (type == 4 && (action = DesktopEventGenerator.getAction((int)event)) == 0) {
            this.setPressed(false);
        }
        return super.handleEvent(event);
    }

    private void setPressed(boolean pressed) {
        this.pressed = pressed;
        this.updateStyle();
        this.requestRender();
    }

    public void handleClick() {
        OnClickListener listener = this.onClickListener;
        if (listener != null) {
            listener.onClick();
        }
    }
}

