/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.tcp;

import ej.hoka.log.HokaLogger;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ServerSocketFactory;

public class TcpServer {
    private static final int DEFAULT_TIMEOUT_DURATION = 60000;
    private final int port;
    private final int maxOpenedConnections;
    private final ServerSocketFactory serverSocketFactory;
    private final int timeout;
    private ServerSocket serverSocket;
    private Thread thread;
    private Socket[] streamConnections;
    private int lastAddedPtr;
    private int lastReadPtr;

    public TcpServer(int port, int maxOpenedConnections) {
        this(port, maxOpenedConnections, ServerSocketFactory.getDefault());
    }

    public TcpServer(int port, int maxOpenedConnections, ServerSocketFactory serverSocketFactory) {
        this(port, maxOpenedConnections, serverSocketFactory, 60000);
    }

    public TcpServer(int port, int maxOpenedConnections, ServerSocketFactory serverSocketFactory, int timeout) {
        if (maxOpenedConnections <= 0 || timeout < 0) {
            throw new IllegalArgumentException();
        }
        this.port = port;
        this.maxOpenedConnections = maxOpenedConnections;
        this.serverSocketFactory = serverSocketFactory;
        this.timeout = timeout;
    }

    public void start() throws IOException {
        if (!this.isStopped()) {
            throw new IllegalStateException();
        }
        this.streamConnections = new Socket[this.maxOpenedConnections + 1];
        this.lastAddedPtr = 0;
        this.lastReadPtr = 0;
        this.serverSocket = this.serverSocketFactory.createServerSocket(this.port);
        this.thread = new Thread(this.newProcess(), this.getName());
        this.thread.start();
        HokaLogger.instance.info("Server started " + this.getInetAddress().getHostAddress() + ":" + this.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            ServerSocket serverSocket = this.serverSocket;
            this.serverSocket = null;
            try {
                serverSocket.close();
            }
            catch (Throwable throwable) {
                this.thread = null;
                return;
            }
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        finally {
            this.thread = null;
        }
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            this.streamConnections.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            HokaLogger.instance.debug("server stopped");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Socket connection) {
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            int nextPtr = this.lastAddedPtr + 1;
            if (nextPtr == this.streamConnections.length) {
                nextPtr = 0;
            }
            if (nextPtr == this.lastReadPtr) {
                HokaLogger.instance.error("too many connections max is:" + this.maxOpenedConnections);
                this.tooManyOpenConnections(connection);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            HokaLogger.instance.trace(String.valueOf(connection.hashCode()) + "\t" + connection.getInetAddress().getHostAddress() + "\t connection received");
            this.streamConnections[nextPtr] = connection;
            this.lastAddedPtr = nextPtr;
            this.streamConnections.notify();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Socket getNextStreamConnection() {
        Socket[] socketArray = this.streamConnections;
        synchronized (this.streamConnections) {
            while (true) {
                if (this.lastAddedPtr != this.lastReadPtr) {
                    int nextPtr = this.lastReadPtr + 1;
                    if (nextPtr == this.streamConnections.length) {
                        nextPtr = 0;
                    }
                    Socket connection = this.streamConnections[nextPtr];
                    this.lastReadPtr = nextPtr;
                    this.streamConnections[nextPtr] = null;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return connection;
                }
                if (this.isStopped()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return null;
                }
                try {
                    this.streamConnections.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean isStopped() {
        return this.serverSocket == null || this.thread == null;
    }

    protected String getName() {
        return TcpServer.class.getSimpleName();
    }

    protected void tooManyOpenConnections(Socket connection) {
        try {
            connection.close();
        }
        catch (IOException e) {
            HokaLogger.instance.error(e);
        }
    }

    private Runnable newProcess() {
        return new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Socket connection = TcpServer.this.serverSocket.accept();
                            connection.setSoTimeout(TcpServer.this.timeout);
                            TcpServer.this.addConnection(connection);
                        }
                    }
                    catch (IOException e) {
                        if (TcpServer.this.isStopped()) {
                            return;
                        }
                        HokaLogger.instance.error(e);
                        continue;
                    }
                    break;
                }
            }
        };
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public InetAddress getInetAddress() {
        return this.serverSocket.getInetAddress();
    }
}

