/*
 * Decompiled with CFR 0.152.
 */
package ej.hoka.http.body;

import ej.hoka.http.body.BodyParser;
import ej.hoka.http.support.UrlDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ParameterParser
implements BodyParser<Map<String, String>> {
    private static final char SPACE_CHAR = ' ';
    private static final char PERCENTAGE_CHAR = '%';
    private static final char NEWLINE_CHAR = '\n';
    private static final char CARRIAGE_RETURN_CHAR = '\r';
    private static final char TABULATION_CHAR = '\t';
    private static final char AMPERSAND_CHAR = '&';
    private static final char EQUAL_CHAR = '=';
    private static final char PLUS_CHAR = '+';
    private static final int END_OF_FILE = -1;

    @Override
    public Map<String, String> parseBody(InputStream inputStream, String contentType) throws IOException {
        HashMap<String, String> body = new HashMap<String, String>();
        ParameterParser.parseParameters(inputStream, body);
        return body;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void parseParameters(InputStream input, Map<String, String> parameters) throws IOException {
        boolean end = false;
        StringBuilder sbKey = new StringBuilder(16);
        StringBuilder sbValue = new StringBuilder(4);
        StringBuilder curBuffer = sbKey;
        block8: while (!end) {
            int i = input.read();
            switch (i) {
                case 37: {
                    i = UrlDecoder.decode(input, curBuffer);
                    break;
                }
                case 43: {
                    i = 32;
                    break;
                }
                case -1: {
                    if (sbKey.length() <= 0) return;
                    parameters.put(sbKey.toString(), sbValue.toString());
                    return;
                }
                case 61: {
                    curBuffer = sbValue;
                    continue block8;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    end = true;
                }
                case 38: {
                    parameters.put(sbKey.toString(), sbValue.toString());
                    sbValue.delete(0, sbValue.length());
                    sbKey.delete(0, sbKey.length());
                    curBuffer = sbKey;
                    continue block8;
                }
            }
            curBuffer.append((char)i);
        }
    }
}

