/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.util;

import ej.bon.Constants;

public class UTF8Validator {
    public static final String CHECK_UTF8_VALIDITY = "ej.websocket.utf8.validation.enabled";

    private UTF8Validator() {
    }

    public static boolean isValid(byte[] bytes, int offset, int length) {
        if (!Constants.getBoolean((String)CHECK_UTF8_VALIDITY)) {
            return true;
        }
        int totalLength = offset + length;
        if (UTF8Validator.checkBounds(bytes, offset, length, totalLength)) {
            return false;
        }
        int numberOfBytesToProcess = 0;
        int firstByte = 0;
        int i = offset;
        while (i < totalLength) {
            int b = bytes[i] & 0xFF;
            if (numberOfBytesToProcess <= 0) {
                if ((numberOfBytesToProcess = UTF8Validator.computeNumberOfBytesToProcess(b, numberOfBytesToProcess)) <= 0 || numberOfBytesToProcess > totalLength - i) {
                    return false;
                }
                firstByte = b;
            } else {
                boolean isInvalidbyte = UTF8Validator.isInvalidByte(b, numberOfBytesToProcess, firstByte);
                if (isInvalidbyte) {
                    return false;
                }
            }
            --numberOfBytesToProcess;
            ++i;
        }
        return numberOfBytesToProcess == 0;
    }

    private static int computeNumberOfBytesToProcess(int b, int numberOfBytesToProcess) {
        if ((b & 0xF0) == 240) {
            if (b > 244) {
                return numberOfBytesToProcess;
            }
            return 4;
        }
        if ((b & 0xE0) == 224) {
            return 3;
        }
        if ((b & 0xC0) == 192) {
            if (b < 194) {
                return numberOfBytesToProcess;
            }
            return 2;
        }
        if ((b & 0x80) == 0) {
            return 1;
        }
        return numberOfBytesToProcess;
    }

    private static boolean isInvalidByte(int b, int numberOfBytesToProcess, int firstByte) {
        boolean isInvalidbyte = (b & 0xC0) != 128;
        isInvalidbyte |= firstByte == 224 && numberOfBytesToProcess == 2 && (b & 0xE0) != 160;
        isInvalidbyte |= firstByte == 237 && numberOfBytesToProcess == 2 && (b & 0xE0) != 128;
        isInvalidbyte |= firstByte == 240 && numberOfBytesToProcess == 3 && (b & 0xF0) != 144 && (b & 0xE0) != 160;
        return isInvalidbyte |= firstByte == 244 && numberOfBytesToProcess == 3 && (b & 0xF0) != 128;
    }

    private static boolean checkBounds(byte[] bytes, int offset, int length, int totalLength) {
        return totalLength > bytes.length || offset < 0 || length < 0;
    }
}

