/*
 * Decompiled with CFR 0.152.
 */
package ej.websocket.frame;

import ej.bon.ByteArray;
import ej.websocket.Messages;
import ej.websocket.WebSocketException;
import ej.websocket.frame.ClientFrameBuilder;
import ej.websocket.frame.RawFrame;
import java.io.IOException;
import java.io.InputStream;

public class FrameScanner {
    private final InputStream is;
    private WAITING_FOR currently;

    public FrameScanner(InputStream is) {
        this.is = is;
        this.currently = WAITING_FOR.FIN_RSV_OPCODE;
    }

    public RawFrame getFrame() throws IOException, WebSocketException {
        byte finRsvOpcode = 0;
        byte maskLength = 0;
        byte[] extendedLength = null;
        long actualPayloadLength = 0L;
        byte[] bytes = new byte[]{};
        while (this.currently != WAITING_FOR.COMPLETE) {
            switch (this.currently) {
                case FIN_RSV_OPCODE: {
                    finRsvOpcode = this.getByteFromStream();
                    this.currently = WAITING_FOR.MASK_AND_LENGTH;
                    break;
                }
                case MASK_AND_LENGTH: {
                    maskLength = this.mask();
                    actualPayloadLength = this.getLength(maskLength, actualPayloadLength);
                    break;
                }
                case EXTENDED_LENGTH: {
                    extendedLength = new byte[]{this.getByteFromStream(), this.getByteFromStream()};
                    actualPayloadLength = ((extendedLength[0] & 0xFF) << 8) + (extendedLength[1] & 0xFF);
                    this.currently = WAITING_FOR.PAYLOAD;
                    break;
                }
                case VERY_EXTENDED_LENGTH: {
                    extendedLength = new byte[8];
                    int totalRead = 0;
                    while (totalRead < extendedLength.length) {
                        int read = this.is.read(extendedLength);
                        if (read == -1) {
                            throw new IOException();
                        }
                        totalRead += read;
                    }
                    actualPayloadLength = ByteArray.readLong((byte[])extendedLength, (int)0, (int)1);
                    this.currently = WAITING_FOR.PAYLOAD;
                    break;
                }
                case MASKING_KEY: {
                    throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
                }
                case PAYLOAD: {
                    bytes = this.getPayload(finRsvOpcode, maskLength, extendedLength, actualPayloadLength);
                    this.currently = WAITING_FOR.COMPLETE;
                    break;
                }
                default: {
                    throw new IllegalStateException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, 9, new Object[]{this.currently}));
                }
            }
        }
        this.currently = WAITING_FOR.FIN_RSV_OPCODE;
        return new RawFrame(bytes);
    }

    private byte[] getPayload(byte finRsvOpcode, byte maskLength, byte[] extendedLength, long actualPayloadLength) throws IOException {
        long frameLength = ClientFrameBuilder.computeFrameLength(actualPayloadLength);
        if (frameLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -4));
        }
        byte[] bytes = new byte[(int)frameLength];
        int offset = 0;
        bytes[offset] = finRsvOpcode;
        bytes[++offset] = maskLength;
        ++offset;
        if (extendedLength != null) {
            byte[] byArray = extendedLength;
            int n = extendedLength.length;
            int n2 = 0;
            while (n2 < n) {
                byte b;
                bytes[offset] = b = byArray[n2];
                ++offset;
                ++n2;
            }
        }
        int totalRead = 0;
        while ((long)totalRead < actualPayloadLength) {
            int length = (int)Math.min(Integer.MAX_VALUE, actualPayloadLength - (long)totalRead);
            int chunkRead = this.is.read(bytes, offset + totalRead, length);
            if (chunkRead == -1) {
                throw new IOException();
            }
            totalRead += chunkRead;
        }
        return bytes;
    }

    private byte mask() throws IOException {
        byte maskLength = this.getByteFromStream();
        if ((maskLength & 0x80) != 0) {
            throw new UnsupportedOperationException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, -3));
        }
        return maskLength;
    }

    private long getLength(byte maskLength, long actualPayloadLength) throws WebSocketException {
        byte payloadLength = (byte)(maskLength & 0x7F);
        if (payloadLength <= 125) {
            actualPayloadLength = payloadLength;
            this.currently = WAITING_FOR.PAYLOAD;
        } else if (payloadLength == 126) {
            this.currently = WAITING_FOR.EXTENDED_LENGTH;
        } else if (payloadLength == 127) {
            this.currently = WAITING_FOR.VERY_EXTENDED_LENGTH;
        } else {
            throw new WebSocketException(Messages.BUILDER.buildMessage('S', Messages.CATEGORY, 9));
        }
        return actualPayloadLength;
    }

    private byte getByteFromStream() throws IOException {
        int b = this.is.read();
        if (b == -1) {
            throw new IOException();
        }
        return (byte)(b & 0xFF);
    }

    private static enum WAITING_FOR {
        FIN_RSV_OPCODE,
        MASK_AND_LENGTH,
        EXTENDED_LENGTH,
        VERY_EXTENDED_LENGTH,
        MASKING_KEY,
        PAYLOAD,
        COMPLETE;

    }
}

