/*
 * Decompiled with CFR 0.152.
 */
package ej.property.registry;

import ej.annotation.Nullable;
import ej.basictool.map.PackedMap;
import ej.property.PropertyPermission;
import ej.property.PropertyRegistry;

public class SimplePropertyRegistry
implements PropertyRegistry {
    private final PackedMap<String, String> properties = new PackedMap();

    @Override
    @Nullable
    public String getProperty(String key) {
        this.checkPropertyPermission(key, "get");
        return (String)this.properties.get((Object)key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        this.checkPropertyPermission(key, "get");
        String value = (String)this.properties.get((Object)key);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    @Nullable
    public String setProperty(String key, String value) {
        this.checkPropertyPermission(key, "set");
        String previous = this.getProperty(key);
        this.properties.put((Object)key, (Object)value);
        return previous;
    }

    @Override
    @Nullable
    public String removeProperty(String key) {
        this.checkPropertyPermission(key, "remove");
        return (String)this.properties.remove((Object)key);
    }

    protected void checkPropertyPermission(String key, String action) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String className = this.getClass().getSimpleName();
            securityManager.checkPermission(new PropertyPermission(className, key, action));
        }
    }
}

