/*
 * Decompiled with CFR 0.152.
 */
package ej.rest.web;

import ej.rest.web.Resty;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public abstract class AbstractResource
extends Resty {
    static final Logger log = Logger.getLogger(AbstractResource.class.getName());
    protected URLConnection urlConnection;
    protected InputStream inputStream;

    public AbstractResource(Resty.Option ... options) {
        super(options);
    }

    protected abstract String getAcceptedTypes();

    void fill(URLConnection anUrlConnection) throws IOException {
        block5: {
            IOException e2;
            block6: {
                HttpURLConnection conn;
                block7: {
                    ByteArrayOutputStream baos;
                    BufferedInputStream es;
                    this.urlConnection = anUrlConnection;
                    try {
                        this.inputStream = anUrlConnection.getInputStream();
                        break block5;
                    }
                    catch (IOException e2) {
                        if (!(anUrlConnection instanceof HttpURLConnection)) break block6;
                        conn = (HttpURLConnection)anUrlConnection;
                        InputStream stream = conn.getErrorStream();
                        if (stream == null) break block7;
                        es = new BufferedInputStream(stream);
                        baos = new ByteArrayOutputStream();
                        try {
                            byte[] buf = new byte[1024];
                            int read = -1;
                            while ((read = ((InputStream)es).read(buf)) > 0) {
                                baos.write(buf, 0, read);
                            }
                        }
                        catch (IOException iOException) {
                            log.warning("IOException when reading the error stream. Ignored");
                        }
                    }
                    ((InputStream)es).close();
                    this.inputStream = new ByteArrayInputStream(baos.toByteArray());
                    break block5;
                }
                conn.disconnect();
                throw e2;
            }
            throw e2;
        }
    }

    public URLConnection getUrlConnection() {
        return this.urlConnection;
    }

    public HttpURLConnection http() {
        return (HttpURLConnection)this.urlConnection;
    }

    public InputStream stream() {
        return this.inputStream;
    }

    public boolean status(int responseCode) {
        if (this.urlConnection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)this.urlConnection;
            try {
                return http.getResponseCode() == responseCode;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public URI location() {
        String loc = this.http().getHeaderField("Location");
        if (loc != null) {
            return URI.create(loc);
        }
        return null;
    }

    public String printResponseHeaders() {
        StringBuilder sb = new StringBuilder();
        HttpURLConnection http = this.http();
        if (http != null) {
            Map<String, List<String>> header = http.getHeaderFields();
            for (String key : header.keySet()) {
                for (String val : header.get(key)) {
                    sb.append(key).append(": ").append(val).append("\n");
                }
            }
        }
        return sb.toString();
    }
}

