/*
 * Decompiled with CFR 0.152.
 */
package com.microej.stringregex;

import ej.basictool.ArrayTools;
import ej.basictool.annotation.Extend;
import java.util.regex.PatternSyntaxException;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class StringRegexExtension {
    @Extend(className="java.lang.String")
    public static String replaceFirst(String self, String regex, String replacement) {
        String subst;
        if ("".equals(regex)) {
            subst = String.valueOf(replacement) + self;
        } else {
            try {
                RE re = new RE(regex);
                subst = re.subst(self, replacement, 3);
            }
            catch (RESyntaxException rese) {
                throw new PatternSyntaxException(rese);
            }
        }
        return subst;
    }

    @Extend(className="java.lang.String")
    public static String replaceAll(String self, String regex, String replacement) {
        String subst;
        if ("".equals(regex)) {
            StringBuilder stringBuilder = new StringBuilder(replacement);
            char[] cArray = self.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                stringBuilder.append(c);
                stringBuilder.append(replacement);
                ++n2;
            }
            subst = stringBuilder.toString();
        } else {
            try {
                RE re = new RE(regex);
                subst = re.subst(self, replacement, 2);
            }
            catch (RESyntaxException rese) {
                throw new PatternSyntaxException(rese);
            }
        }
        return subst;
    }

    @Extend(className="java.lang.String")
    public static String[] split(String self, String regex) {
        Object[] fullSplit;
        try {
            RE re = new RE(regex);
            fullSplit = re.split(self);
        }
        catch (RESyntaxException rese) {
            throw new PatternSyntaxException(rese);
        }
        int nbTrailingEmpties = 0;
        int i = fullSplit.length - 1;
        while (i >= 0) {
            if (!fullSplit[i].equals("")) break;
            ++nbTrailingEmpties;
            --i;
        }
        return (String[])ArrayTools.shrink((Object[])fullSplit, (int)(fullSplit.length - nbTrailingEmpties), (int)nbTrailingEmpties);
    }

    @Extend(className="java.lang.String")
    public static boolean matches(String self, String regex) {
        boolean match;
        try {
            if (regex != null) {
                regex = "^(?:" + regex + ")$";
            }
            RE re = new RE(regex);
            match = re.match(self);
        }
        catch (RESyntaxException rese) {
            throw new PatternSyntaxException(rese);
        }
        return match;
    }
}

