/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.module;

import com.microej.kf.util.module.ApplicationModule;
import com.microej.kf.util.module.KernelModule;
import com.microej.kf.util.module.SandboxedModule;
import com.microej.kf.util.module.SandboxedModuleHelper;
import ej.annotation.Nullable;
import ej.kf.Feature;
import ej.kf.FeatureStateListener;
import ej.kf.Kernel;
import ej.kf.Module;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SandboxedModuleManager
implements SandboxedModuleHelper,
FeatureStateListener {
    private static final Logger LOGGER = Logger.getLogger("ModuleManager");
    private final ArrayList<SandboxedModule> modules = new ArrayList();

    public SandboxedModuleManager() {
        this.modules.add(new KernelModule());
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Registering Application State Change Listener");
        }
        Kernel.addFeatureStateListener((FeatureStateListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public SandboxedModule getModule(String moduleName) {
        ArrayList<SandboxedModule> arrayList = this.modules;
        synchronized (arrayList) {
            for (SandboxedModule module : this.modules) {
                if (!module.getIdentifier().equals(moduleName)) continue;
                return module;
            }
        }
        return null;
    }

    @Override
    public SandboxedModule getCurrentModule() {
        Module module = Kernel.getContextOwner();
        Kernel.enter();
        return this.getModule(module.getName());
    }

    @Override
    public void configureInstalledFeatures() {
        Feature[] featureArray = Kernel.getAllLoadedFeatures();
        int n = featureArray.length;
        int n2 = 0;
        while (n2 < n) {
            Feature app = featureArray[n2];
            this.onInstalled(app);
            ++n2;
        }
    }

    public void stateChanged(Feature app, @Nullable Feature.State previousState) {
        switch (app.getState()) {
            case STARTED: {
                this.onStarted(app);
                break;
            }
            case STOPPED: {
                this.onStopped(app);
                break;
            }
            case INSTALLED: {
                if (previousState == null) {
                    this.onInstalled(app);
                    break;
                }
                if (!Feature.State.STOPPED.equals((Object)previousState)) break;
                this.onStopCompleted(app);
                break;
            }
            case UNINSTALLED: {
                this.onUninstalled(app);
                break;
            }
        }
    }

    private void onInstalled(Feature app) {
        block4: {
            ApplicationModule appModule;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("New application installation detected: " + app.getName());
            }
            if (!this.contains(appModule = new ApplicationModule(app))) {
                this.add(appModule);
                try {
                    appModule.applyPolicy();
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block4;
                    LOGGER.log(Level.SEVERE, "Error while applying the policy file", e);
                }
            }
        }
    }

    private void onStarted(Feature app) {
        ApplicationModule appModule;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Application running: " + app.getName());
        }
        if ((appModule = (ApplicationModule)this.getModule(app.getName())) != null) {
            appModule.applyThreadPriority();
        }
    }

    private void onStopped(Feature app) {
        ApplicationModule appModule;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Application stopped: " + app.getName());
        }
        if ((appModule = (ApplicationModule)this.getModule(app.getName())) != null) {
            appModule.getFileSystemResourceController().reset();
            appModule.getNetworkResourceController().reset();
        }
    }

    private void onStopCompleted(Feature app) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Application completely stopped, and can be uninstalled: " + app.getName());
        }
    }

    private void onUninstalled(Feature app) {
        ApplicationModule appModule;
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("Application uninstalled: " + app.getName());
        }
        if ((appModule = (ApplicationModule)this.getModule(app.getName())) != null) {
            this.remove(appModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(ApplicationModule app) {
        ArrayList<SandboxedModule> arrayList = this.modules;
        synchronized (arrayList) {
            this.modules.add(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ApplicationModule app) {
        ArrayList<SandboxedModule> arrayList = this.modules;
        synchronized (arrayList) {
            this.modules.remove(app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean contains(ApplicationModule app) {
        ArrayList<SandboxedModule> arrayList = this.modules;
        synchronized (arrayList) {
            return this.modules.contains(app);
        }
    }
}

