/*
 * Decompiled with CFR 0.152.
 */
package com.microej.kf.util.control.net;

import com.microej.kf.util.control.net.CloseSocket;
import com.microej.kf.util.control.net.ReadSocket;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;

public class SocketInputStream
extends FilterInputStream {
    private final Socket socket;
    private static final Object lock = new Object();

    public SocketInputStream(Socket socket, InputStream inputstream) throws IOException {
        super(inputstream);
        this.socket = socket;
    }

    @Override
    public int read() throws IOException {
        Object object = lock;
        synchronized (object) {
            ReadSocket readSocket = new ReadSocket(this.socket, 1);
            readSocket.onStart();
            try {
                int value = super.read();
                readSocket.onEnd(value);
                return value;
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                readSocket.onEnd(-1);
                throw e;
            }
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        Object object = lock;
        synchronized (object) {
            ReadSocket readSocket = new ReadSocket(this.socket, len);
            int bytesAvailable = readSocket.onStart();
            try {
                int value = super.read(b, off, bytesAvailable);
                readSocket.onEnd(value);
                return value;
            }
            catch (IOException | IllegalArgumentException | SecurityException e) {
                readSocket.onEnd(-1);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = lock;
        synchronized (object) {
            boolean wasClosed = this.socket.isClosed();
            super.close();
            if (!wasClosed) {
                CloseSocket closeSocket = new CloseSocket(this.socket);
                closeSocket.onEnd(true);
            }
        }
    }
}

