/*
 * Decompiled with CFR 0.152.
 */
package ej.bluetooth.util.server;

import ej.bluetooth.BluetoothDevice;
import ej.bluetooth.util.BluetoothServicesUtil;
import ej.bluetooth.util.server.BasicServerDescriptor;
import ej.bluetooth.util.server.ServerStorage;

public class CCCDescriptor
extends BasicServerDescriptor {
    public CCCDescriptor() {
        super(BluetoothServicesUtil.CCC_UUID, 9);
    }

    @Override
    public void onReadRequest(BluetoothDevice device) {
        byte[] value = ServerStorage.get(device, this);
        if (value == null) {
            value = new byte[2];
        }
        this.sendReadResponse(device, 0, value);
    }

    @Override
    public void onWriteRequest(BluetoothDevice device, byte[] value) {
        if (value.length == 2) {
            ServerStorage.set(device, this, value);
            this.sendWriteResponse(device, 0);
        } else {
            this.sendWriteResponse(device, 13);
        }
    }

    public boolean shouldNotify(BluetoothDevice device) {
        byte[] bs = ServerStorage.get(device, this);
        return bs != null && BluetoothServicesUtil.checkCccNotifications(bs);
    }

    public boolean shouldIndicate(BluetoothDevice device) {
        byte[] bs = ServerStorage.get(device, this);
        return bs != null && BluetoothServicesUtil.checkCccNIndication(bs);
    }
}

