/*
 * Decompiled with CFR 0.152.
 */
package ej.widget.debug;

import ej.mwt.Container;
import ej.mwt.Widget;
import ej.widget.debug.HierarchyInspector;

public class BoundsInspector {
    private static final String ABSOLUTE = "absolute:";

    private BoundsInspector() {
    }

    public static String boundsToString(Widget widget) {
        StringBuilder builder = new StringBuilder();
        BoundsInspector.appendBounds(builder, widget);
        return builder.toString();
    }

    public static String boundsRecursiveToString(Widget widget) {
        StringBuilder builder = new StringBuilder();
        BoundsInspector.appendBoundsRecursive(builder, widget, 0);
        return builder.toString();
    }

    private static void appendBoundsRecursive(StringBuilder builder, Widget widget, int depth) {
        HierarchyInspector.appendDepth(builder, depth);
        BoundsInspector.appendBounds(builder, widget);
        builder.append('\n');
        if (widget instanceof Container) {
            BoundsInspector.appendChildrenBounds(builder, (Container)widget, depth);
        }
    }

    private static void appendChildrenBounds(StringBuilder builder, Container container, int depth) {
        int childrenCount = container.getChildrenCount();
        int i = 0;
        while (i < childrenCount) {
            Widget child = container.getChild(i);
            BoundsInspector.appendBoundsRecursive(builder, child, depth + 1);
            ++i;
        }
    }

    private static void appendBounds(StringBuilder builder, Widget widget) {
        HierarchyInspector.appendElement(builder, widget);
        builder.append(':').append(' ');
        BoundsInspector.appendRelativePosition(builder, widget);
        builder.append(' ');
        BoundsInspector.appendSize(builder, widget);
        builder.append(' ').append('(').append(ABSOLUTE).append(' ');
        BoundsInspector.appendAbsolutePosition(builder, widget);
        builder.append(')');
    }

    private static void appendRelativePosition(StringBuilder builder, Widget widget) {
        builder.append(widget.getX()).append(',').append(widget.getY());
    }

    static void appendSize(StringBuilder builder, Widget widget) {
        builder.append(widget.getWidth()).append('x').append(widget.getHeight());
    }

    static void appendAbsolutePosition(StringBuilder builder, Widget widget) {
        builder.append(widget.getAbsoluteX()).append(',').append(widget.getAbsoluteY());
    }
}

