/*
 * Decompiled with CFR 0.152.
 */
package ej.mwt;

import ej.annotation.NonNull;
import ej.annotation.Nullable;
import ej.microui.event.Event;
import ej.microui.event.EventGenerator;
import ej.microui.event.generator.Buttons;
import ej.microui.event.generator.Pointer;
import ej.microui.util.EventHandler;
import ej.mwt.Desktop;
import ej.mwt.ExtendedPointer;
import ej.mwt.Panel;
import ej.mwt.Renderable;
import ej.mwt.Widget;

public class DesktopEventManagementPolicy
implements EventHandler {
    @NonNull
    private final Desktop desktop;

    public DesktopEventManagementPolicy(@NonNull Desktop desktop) {
        this.desktop = desktop;
    }

    public boolean handleEvent(int event) {
        int type = Event.getType((int)event);
        if (type == 3) {
            this.pointerEvent(event);
        } else {
            Panel panel = this.desktop.getActivePanel();
            if (panel != null) {
                if (this.desktop.isAccessible(panel)) {
                    Widget focus = panel.getFocus();
                    this.sendEventHierarchy(panel, focus, event);
                }
            } else {
                this.desktop.handleEvent(event);
            }
        }
        return false;
    }

    private void pointerEvent(int event) {
        Pointer pointer = (Pointer)Event.getGenerator((int)event);
        ExtendedPointer xPointer = ExtendedPointer.getXPointer(pointer);
        int action = Buttons.getAction((int)event);
        Renderable renderablePressed = xPointer.getRenderablePressed();
        this.updatePointer(xPointer, pointer);
        Renderable renderableUnder = xPointer.getRenderableUnder();
        switch (action) {
            case 7: {
                this.dragged(event, pointer, xPointer, renderablePressed, renderableUnder);
                break;
            }
            case 6: {
                this.moved(event, renderableUnder);
                break;
            }
            case 0: {
                this.pressed(event, pointer, xPointer, renderableUnder);
                break;
            }
            case 1: {
                this.released(event, pointer, xPointer, renderablePressed);
            }
        }
    }

    private void dragged(int event, @NonNull Pointer pointer, @NonNull ExtendedPointer xPointer, @Nullable Renderable renderablePressed, @Nullable Renderable renderableUnder) {
        if (renderablePressed != null) {
            this.sendEventToRenderable(renderablePressed, event);
        } else {
            Renderable renderable = this.sendEventToRenderableHierarchy(renderableUnder, event);
            if (renderable != null) {
                xPointer.setRenderablePressed(renderable);
                this.sendExit(pointer, renderableUnder, renderable);
            }
        }
    }

    private void moved(int event, @Nullable Renderable renderableUnder) {
        this.sendEventToRenderableHierarchy(renderableUnder, event);
    }

    private void pressed(int event, @NonNull Pointer pointer, @NonNull ExtendedPointer xPointer, @Nullable Renderable renderableUnder) {
        if (renderableUnder != null) {
            Panel panelUnder = this.getPanel(renderableUnder);
            this.desktop.setActivePanelInternal(panelUnder);
            Renderable renderablePressed = this.sendEventToRenderableHierarchy(renderableUnder, event);
            if (renderablePressed != null) {
                xPointer.setRenderablePressed(renderablePressed);
                this.focusRenderable(renderablePressed);
                this.sendExit(pointer, renderableUnder, renderablePressed);
            }
        }
    }

    @Nullable
    private Panel getPanel(@NonNull Renderable renderable) {
        if (renderable instanceof Widget) {
            Widget widget = (Widget)renderable;
            return widget.getPanel();
        }
        if (renderable instanceof Panel) {
            return (Panel)renderable;
        }
        return null;
    }

    private void released(int event, @NonNull Pointer pointer, @NonNull ExtendedPointer xPointer, @Nullable Renderable renderablePressed) {
        if (pointer.buttonsState == 0) {
            xPointer.setRenderablePressed(null);
        }
        if (renderablePressed != null) {
            this.sendEventToRenderable(renderablePressed, event);
        } else {
            Renderable renderableUnder = xPointer.getRenderableUnder();
            renderablePressed = this.sendEventToRenderableHierarchy(renderableUnder, event);
            if (renderablePressed != null) {
                this.focusRenderable(renderablePressed);
                this.sendExit(pointer, renderableUnder, renderablePressed);
            }
        }
    }

    private void focusRenderable(@Nullable Renderable renderablePressed) {
        Widget widget;
        Panel panel;
        if (renderablePressed != null && renderablePressed instanceof Widget && (panel = (widget = (Widget)renderablePressed).getPanel()) != null) {
            panel.setFocus(widget);
        }
    }

    private void updatePointer(@NonNull ExtendedPointer xPointer, @NonNull Pointer pointer) {
        Renderable renderable;
        int x = pointer.getX();
        int y = pointer.getY();
        Renderable oldRenderable = xPointer.getRenderableUnder();
        Panel panel = this.desktop.panelAt(x, y);
        if (panel != null && this.desktop.isAccessible(panel)) {
            Widget widget = panel.getWidgetAt(x, y);
            while (widget != null && !widget.isEnabled()) {
                widget = widget.getParent();
            }
            renderable = widget != null ? widget : panel;
        } else {
            renderable = this.desktop;
        }
        xPointer.setRenderableUnder(renderable);
        if (oldRenderable != renderable) {
            if (oldRenderable != null && oldRenderable.isShown()) {
                this.sendExitToRenderableHierarchy(oldRenderable, pointer, x, y);
            }
            this.sendEnterToRenderableHierarchy(renderable, oldRenderable, pointer, x, y);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendExit(@NonNull Pointer pointer, @Nullable Renderable renderableUnder, @Nullable Renderable renderablePressed) {
        Panel panel;
        Widget widget;
        int event = this.buildEvent(pointer, 9);
        if (renderableUnder instanceof Widget) {
            widget = (Widget)renderableUnder;
            panel = widget.getPanel();
        } else {
            if (!(renderableUnder instanceof Panel)) {
                return;
            }
            widget = null;
            panel = (Panel)renderableUnder;
        }
        while (widget != null) {
            if (widget == renderablePressed) {
                return;
            }
            if (widget.isEnabled()) {
                widget.handleEvent(event);
            }
            widget = widget.getParent();
        }
        if (panel != renderablePressed && panel != null) {
            panel.handleEvent(event);
        }
    }

    private void sendExitToRenderableHierarchy(@NonNull Renderable renderable, @NonNull Pointer pointer, int x, int y) {
        if (renderable instanceof Widget) {
            Widget widget = (Widget)renderable;
            this.sendExitEventHierarchy(widget.getPanel(), widget, pointer, x, y);
        } else if (renderable instanceof Panel) {
            this.sendExitEventHierarchy((Panel)renderable, null, pointer, x, y);
        }
    }

    private void sendExitEventHierarchy(@Nullable Panel panel, @Nullable Widget widget, @NonNull Pointer pointer, int x, int y) {
        int event = this.buildEvent(pointer, 9);
        while (widget != null) {
            if (widget.isShown() && widget.contains(x - widget.getAbsoluteXInternal() + widget.x, y - widget.getAbsoluteYInternal() + widget.y)) {
                return;
            }
            if (widget.isEnabled()) {
                widget.handleEvent(event);
            }
            widget = widget.getParent();
        }
        if (panel != null && !panel.contains(x, y)) {
            panel.handleEvent(event);
        }
    }

    private void sendEnterToRenderableHierarchy(@Nullable Renderable renderable, @Nullable Renderable oldRenderable, @NonNull Pointer pointer, int x, int y) {
        Panel oldPanel;
        Widget oldWidget;
        Panel panel;
        Widget widget;
        if (renderable instanceof Widget) {
            widget = (Widget)renderable;
            panel = widget.panel;
        } else if (renderable instanceof Panel) {
            panel = (Panel)renderable;
            widget = null;
        } else {
            return;
        }
        if (oldRenderable instanceof Widget) {
            oldWidget = (Widget)oldRenderable;
            oldPanel = oldWidget.getPanel();
        } else if (oldRenderable instanceof Panel) {
            oldPanel = (Panel)oldRenderable;
            oldWidget = null;
        } else {
            oldPanel = null;
            oldWidget = null;
        }
        this.sendEnterEventHierarchy(panel, widget, oldPanel, oldWidget, pointer, x, y);
    }

    private void sendEnterEventHierarchy(@Nullable Panel panel, @Nullable Widget widget, @Nullable Panel oldPanel, @Nullable Widget oldWidget, @NonNull Pointer pointer, int x, int y) {
        int event = this.buildEvent(pointer, 8);
        while (widget != null) {
            Widget widgetCandidate = oldWidget;
            while (widgetCandidate != null) {
                if (widget == widgetCandidate) {
                    return;
                }
                widgetCandidate = widgetCandidate.getParent();
            }
            if (widget.isEnabled()) {
                widget.handleEvent(event);
            }
            widget = widget.getParent();
        }
        if (panel != null && panel != oldPanel) {
            panel.handleEvent(event);
        }
    }

    private int buildEvent(@NonNull Pointer pointer, int action) {
        int event = Event.buildEvent((int)pointer.getEventType(), (EventGenerator)pointer, (int)Pointer.buildEventData((int)action, (int)0));
        return event;
    }

    private Renderable sendEventHierarchy(@Nullable Panel panel, @Nullable Widget widget, int event) {
        while (widget != null) {
            if (widget.isEnabled() && widget.handleEvent(event)) {
                return widget;
            }
            widget = widget.getParent();
        }
        if (panel != null && panel.handleEvent(event)) {
            return panel;
        }
        if (this.desktop.handleEvent(event)) {
            return this.desktop;
        }
        return null;
    }

    private Renderable sendEventToRenderableHierarchy(@Nullable Renderable renderable, int event) {
        if (renderable instanceof Widget) {
            Widget widget = (Widget)renderable;
            return this.sendEventHierarchy(widget.getPanel(), widget, event);
        }
        if (renderable instanceof Panel) {
            return this.sendEventHierarchy((Panel)renderable, null, event);
        }
        return this.sendEventHierarchy(null, null, event);
    }

    private void sendEventToRenderable(@Nullable Renderable renderable, int event) {
        if (renderable != null) {
            renderable.handleEvent(event);
        }
    }
}

